/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SphericalMercatorUtils;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.Field;
import org.elasticsearch.script.FieldValues;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafGeoShapeFieldData;

public abstract class AbstractAtomicGeoShapeShapeFieldData
implements LeafGeoShapeFieldData {
    public final SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("scripts and term aggs are not supported by geo_shape doc values");
    }

    public final ScriptDocValues.Geometry<GeoShapeValues.GeoShapeValue> getScriptValues() {
        return new GeoShapeScriptValues(this.getGeoShapeValues());
    }

    public static LeafGeoShapeFieldData empty(int maxDoc) {
        return new AbstractAtomicGeoShapeShapeFieldData(){

            public long ramBytesUsed() {
                return 0L;
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            public void close() {
            }

            @Override
            public GeoShapeValues getGeoShapeValues() {
                return GeoShapeValues.EMPTY;
            }
        };
    }

    private static final class GeoShapeScriptValues
    extends ScriptDocValues.Geometry<GeoShapeValues.GeoShapeValue> {
        private final GeoShapeValues in;
        private final GeoPoint centroid = new GeoPoint();
        private final GeoBoundingBox boundingBox = new GeoBoundingBox(new GeoPoint(), new GeoPoint());
        private GeoShapeValues.GeoShapeValue value;

        private GeoShapeScriptValues(GeoShapeValues in) {
            this.in = in;
        }

        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.value = this.in.value();
                this.centroid.reset(this.value.lat(), this.value.lon());
                this.boundingBox.topLeft().reset(this.value.boundingBox().maxY(), this.value.boundingBox().minX());
                this.boundingBox.bottomRight().reset(this.value.boundingBox().minY(), this.value.boundingBox().maxX());
            } else {
                this.value = null;
            }
        }

        public int getDimensionalType() {
            return this.value == null ? -1 : this.value.dimensionalShapeType().ordinal();
        }

        public GeoPoint getCentroid() {
            return this.value == null ? null : this.centroid;
        }

        public double getMercatorWidth() {
            return SphericalMercatorUtils.lonToSphericalMercator((double)this.boundingBox.right()) - SphericalMercatorUtils.lonToSphericalMercator((double)this.boundingBox.left());
        }

        public double getMercatorHeight() {
            return SphericalMercatorUtils.latToSphericalMercator((double)this.boundingBox.top()) - SphericalMercatorUtils.latToSphericalMercator((double)this.boundingBox.bottom());
        }

        public GeoBoundingBox getBoundingBox() {
            return this.value == null ? null : this.boundingBox;
        }

        public GeoShapeValues.GeoShapeValue get(int index) {
            return this.value;
        }

        public int size() {
            return this.value == null ? 0 : 1;
        }

        public Field<GeoShapeValues.GeoShapeValue> toField(String fieldName) {
            return new GeoShapeField(fieldName, (FieldValues<GeoShapeValues.GeoShapeValue>)this);
        }
    }

    public static class GeoShapeField
    extends Field<GeoShapeValues.GeoShapeValue> {
        public GeoShapeField(String name, FieldValues<GeoShapeValues.GeoShapeValue> values) {
            super(name, values);
        }
    }
}

