/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.encrypted;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.internal.io.IOUtils;

public abstract class ChainingInputStream
extends InputStream {
    private static final Logger LOGGER = LogManager.getLogger(ChainingInputStream.class);
    protected static final InputStream EXHAUSTED_MARKER = new ByteArrayInputStream(new byte[0]);
    protected InputStream currentIn;
    protected InputStream markIn;
    private boolean closed;

    public static ChainingInputStream chain(final InputStream first, final InputStream second) {
        if (!Objects.requireNonNull(first).markSupported()) {
            throw new IllegalArgumentException("The first component input stream does not support mark");
        }
        if (!Objects.requireNonNull(second).markSupported()) {
            throw new IllegalArgumentException("The second component input stream does not support mark");
        }
        final InputStream firstComponent = Streams.noCloseStream((InputStream)first);
        final InputStream secondComponent = Streams.noCloseStream((InputStream)second);
        firstComponent.mark(Integer.MAX_VALUE);
        secondComponent.mark(Integer.MAX_VALUE);
        return new ChainingInputStream(){

            @Override
            InputStream nextComponent(InputStream currentComponentIn) throws IOException {
                if (currentComponentIn == null) {
                    firstComponent.reset();
                    return firstComponent;
                }
                if (currentComponentIn == firstComponent) {
                    secondComponent.reset();
                    return secondComponent;
                }
                if (currentComponentIn == secondComponent) {
                    return null;
                }
                throw new IllegalStateException("Unexpected component input stream");
            }

            @Override
            public void close() throws IOException {
                IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), first, second});
            }
        };
    }

    @Nullable
    abstract InputStream nextComponent(@Nullable InputStream var1) throws IOException;

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        do {
            int byteVal;
            int n = byteVal = this.currentIn == null ? -1 : this.currentIn.read();
            if (byteVal == -1) continue;
            return byteVal;
        } while (this.nextIn());
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if ((b.length | off | len) < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Range [%d, %<d + %d) out of bounds for length %d", off, len, b.length));
        }
        if (len == 0) {
            return 0;
        }
        do {
            int bytesRead;
            int n = bytesRead = this.currentIn == null ? -1 : this.currentIn.read(b, off, len);
            if (bytesRead == -1) continue;
            return bytesRead;
        } while (this.nextIn());
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        if (this.currentIn == null) {
            this.nextIn();
        }
        long bytesRemaining = n;
        while (bytesRemaining > 0L) {
            long bytesSkipped = this.currentIn.skip(bytesRemaining);
            if (bytesSkipped == 0L) {
                int byteRead = this.read();
                if (byteRead == -1) break;
                --bytesRemaining;
                continue;
            }
            bytesRemaining -= bytesSkipped;
        }
        return n - bytesRemaining;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.currentIn == null) {
            this.nextIn();
        }
        return this.currentIn.available();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        if (this.markSupported() && !this.closed) {
            if (this.markIn != null && this.markIn != EXHAUSTED_MARKER && this.currentIn != this.markIn) {
                try {
                    this.markIn.close();
                }
                catch (IOException e) {
                    LOGGER.info("IOException while closing a marked component input stream during a mark", (Throwable)e);
                }
            }
            this.markIn = this.currentIn;
            if (this.markIn != null && this.markIn != EXHAUSTED_MARKER) {
                this.markIn.mark(readlimit);
            }
        }
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (!this.markSupported()) {
            throw new IOException("Mark/reset not supported");
        }
        if (this.currentIn != null && this.currentIn != EXHAUSTED_MARKER && this.currentIn != this.markIn) {
            try {
                this.currentIn.close();
            }
            catch (IOException e) {
                LOGGER.info("IOException while closing the current component input stream during a reset", (Throwable)e);
            }
        }
        this.currentIn = this.markIn;
        if (this.currentIn != null && this.currentIn != EXHAUSTED_MARKER) {
            this.currentIn.reset();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.currentIn != null && this.currentIn != EXHAUSTED_MARKER) {
                this.currentIn.close();
            }
            if (this.markIn != null && this.markIn != this.currentIn && this.markIn != EXHAUSTED_MARKER) {
                this.markIn.close();
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }

    private boolean nextIn() throws IOException {
        if (this.currentIn == EXHAUSTED_MARKER) {
            return false;
        }
        if (this.currentIn != null && this.currentIn != this.markIn) {
            this.currentIn.close();
        }
        this.currentIn = this.nextComponent(this.currentIn);
        if (this.currentIn == null) {
            this.currentIn = EXHAUSTED_MARKER;
            return false;
        }
        if (this.markSupported() && !this.currentIn.markSupported()) {
            throw new IllegalStateException("Component input stream must support mark");
        }
        return true;
    }
}

