/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.List;
import java.util.function.Function;

public class ApiKeyFieldNameTranslators {
    static final List<FieldNameTranslator> FIELD_NAME_TRANSLATORS = org.elasticsearch.core.List.of((Object[])new FieldNameTranslator[]{new ExactFieldNameTranslator(s -> "creator.principal", "username"), new ExactFieldNameTranslator(s -> "creator.realm", "realm_name"), new ExactFieldNameTranslator(Function.identity(), "name"), new ExactFieldNameTranslator(s -> "creation_time", "creation"), new ExactFieldNameTranslator(s -> "expiration_time", "expiration"), new ExactFieldNameTranslator(s -> "api_key_invalidated", "invalidated"), new PrefixFieldNameTranslator(s -> "metadata_flattened" + s.substring(8), "metadata.")});

    public static String translate(String fieldName) {
        for (FieldNameTranslator translator : FIELD_NAME_TRANSLATORS) {
            if (!translator.supports(fieldName)) continue;
            return translator.translate(fieldName);
        }
        throw new IllegalArgumentException("Field [" + fieldName + "] is not allowed for API Key query");
    }

    static abstract class FieldNameTranslator {
        private final Function<String, String> translationFunc;

        protected FieldNameTranslator(Function<String, String> translationFunc) {
            this.translationFunc = translationFunc;
        }

        String translate(String fieldName) {
            return this.translationFunc.apply(fieldName);
        }

        abstract boolean supports(String var1);
    }

    static class ExactFieldNameTranslator
    extends FieldNameTranslator {
        private final String name;

        ExactFieldNameTranslator(Function<String, String> translationFunc, String name) {
            super(translationFunc);
            this.name = name;
        }

        @Override
        public boolean supports(String fieldName) {
            return this.name.equals(fieldName);
        }
    }

    static class PrefixFieldNameTranslator
    extends FieldNameTranslator {
        private final String prefix;

        PrefixFieldNameTranslator(Function<String, String> translationFunc, String prefix) {
            super(translationFunc);
            this.prefix = prefix;
        }

        @Override
        boolean supports(String fieldName) {
            return fieldName.startsWith(this.prefix);
        }
    }
}

