/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationServiceField;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.authc.support.RealmUserLookup;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class AuthenticationService {
    static final Setting<Boolean> SUCCESS_AUTH_CACHE_ENABLED = Setting.boolSetting((String)"xpack.security.authc.success_cache.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> SUCCESS_AUTH_CACHE_MAX_SIZE = Setting.intSetting((String)"xpack.security.authc.success_cache.size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> SUCCESS_AUTH_CACHE_EXPIRE_AFTER_ACCESS = Setting.timeSetting((String)"xpack.security.authc.success_cache.expire_after_access", (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(AuthenticationService.class);
    private final Realms realms;
    private final AuditTrailService auditTrailService;
    private final AuthenticationFailureHandler failureHandler;
    private final ThreadContext threadContext;
    private final String nodeName;
    private final AnonymousUser anonymousUser;
    private final TokenService tokenService;
    private final Cache<String, Realm> lastSuccessfulAuthCache;
    private final AtomicLong numInvalidation = new AtomicLong();
    private final ApiKeyService apiKeyService;
    private final ServiceAccountService serviceAccountService;
    private final OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService;
    private final boolean runAsEnabled;
    private final boolean isAnonymousUserEnabled;
    private final AuthenticationContextSerializer authenticationSerializer;

    public AuthenticationService(Settings settings, Realms realms, AuditTrailService auditTrailService, AuthenticationFailureHandler failureHandler, ThreadPool threadPool, AnonymousUser anonymousUser, TokenService tokenService, ApiKeyService apiKeyService, ServiceAccountService serviceAccountService, OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService) {
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.realms = realms;
        this.auditTrailService = auditTrailService;
        this.failureHandler = failureHandler;
        this.threadContext = threadPool.getThreadContext();
        this.anonymousUser = anonymousUser;
        this.runAsEnabled = (Boolean)AuthenticationServiceField.RUN_AS_ENABLED.get(settings);
        this.isAnonymousUserEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        this.tokenService = tokenService;
        this.lastSuccessfulAuthCache = (Boolean)SUCCESS_AUTH_CACHE_ENABLED.get(settings) != false ? CacheBuilder.builder().setMaximumWeight(Integer.toUnsignedLong((Integer)SUCCESS_AUTH_CACHE_MAX_SIZE.get(settings))).setExpireAfterAccess((TimeValue)SUCCESS_AUTH_CACHE_EXPIRE_AFTER_ACCESS.get(settings)).build() : null;
        this.apiKeyService = apiKeyService;
        this.serviceAccountService = serviceAccountService;
        this.operatorPrivilegesService = operatorPrivilegesService;
        this.authenticationSerializer = new AuthenticationContextSerializer();
    }

    public void authenticate(RestRequest request, ActionListener<Authentication> authenticationListener) {
        this.authenticate(request, true, authenticationListener);
    }

    public void authenticate(RestRequest request, boolean allowAnonymous, ActionListener<Authentication> authenticationListener) {
        this.createAuthenticator(request, allowAnonymous, authenticationListener).authenticateAsync();
    }

    public void authenticate(String action, TransportRequest transportRequest, User fallbackUser, ActionListener<Authentication> listener) {
        Objects.requireNonNull(fallbackUser, "fallback user may not be null");
        this.createAuthenticator(action, transportRequest, fallbackUser, listener).authenticateAsync();
    }

    public void authenticate(String action, TransportRequest transportRequest, boolean allowAnonymous, ActionListener<Authentication> listener) {
        this.createAuthenticator(action, transportRequest, allowAnonymous, listener).authenticateAsync();
    }

    public void authenticate(String action, TransportRequest transportRequest, AuthenticationToken token, ActionListener<Authentication> listener) {
        new Authenticator(action, transportRequest, this.shouldFallbackToAnonymous(true), listener).consumeToken(token);
    }

    public void expire(String principal) {
        if (this.lastSuccessfulAuthCache != null) {
            this.numInvalidation.incrementAndGet();
            this.lastSuccessfulAuthCache.invalidate((Object)principal);
        }
    }

    public void expireAll() {
        if (this.lastSuccessfulAuthCache != null) {
            this.numInvalidation.incrementAndGet();
            this.lastSuccessfulAuthCache.invalidateAll();
        }
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (this.lastSuccessfulAuthCache != null && (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || !Objects.equals(previousState.indexUUID, currentState.indexUUID))) {
            this.expireAll();
        }
    }

    Authenticator createAuthenticator(RestRequest request, boolean fallbackToAnonymous, ActionListener<Authentication> listener) {
        return new Authenticator(request, this.shouldFallbackToAnonymous(fallbackToAnonymous), listener);
    }

    Authenticator createAuthenticator(String action, TransportRequest transportRequest, boolean fallbackToAnonymous, ActionListener<Authentication> listener) {
        return new Authenticator(action, transportRequest, this.shouldFallbackToAnonymous(fallbackToAnonymous), listener);
    }

    Authenticator createAuthenticator(String action, TransportRequest transportRequest, User fallbackUser, ActionListener<Authentication> listener) {
        return new Authenticator(action, transportRequest, fallbackUser, listener);
    }

    long getNumInvalidation() {
        return this.numInvalidation.get();
    }

    boolean shouldFallbackToAnonymous(boolean allowAnonymousOnThisRequest) {
        if (!this.isAnonymousUserEnabled) {
            return false;
        }
        if (!allowAnonymousOnThisRequest) {
            return false;
        }
        String header = this.threadContext.getHeader("Authorization");
        return !Strings.hasText((String)header) || (!header.regionMatches(true, 0, "Bearer ", 0, "Bearer ".length()) || header.length() <= "Bearer ".length()) && (!header.regionMatches(true, 0, "ApiKey ", 0, "ApiKey ".length()) || header.length() <= "ApiKey ".length());
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(AuthenticationServiceField.RUN_AS_ENABLED);
        settings.add(SUCCESS_AUTH_CACHE_ENABLED);
        settings.add(SUCCESS_AUTH_CACHE_MAX_SIZE);
        settings.add(SUCCESS_AUTH_CACHE_EXPIRE_AFTER_ACCESS);
    }

    class Authenticator {
        private final AuditableRequest request;
        private final User fallbackUser;
        private final boolean fallbackToAnonymous;
        private final List<Realm> defaultOrderedRealmList;
        private final ActionListener<Authentication> listener;
        private Authentication.RealmRef authenticatedBy = null;
        private Authentication.RealmRef lookedupBy = null;
        private AuthenticationToken authenticationToken = null;
        private AuthenticationResult authenticationResult = null;

        Authenticator(RestRequest request, boolean fallbackToAnonymous, ActionListener<Authentication> listener) {
            this(new AuditableRestRequest(this$0.auditTrailService.get(), this$0.failureHandler, this$0.threadContext, request), null, fallbackToAnonymous, listener);
        }

        Authenticator(String action, TransportRequest transportRequest, boolean fallbackToAnonymous, ActionListener<Authentication> listener) {
            this(new AuditableTransportRequest(this$0.auditTrailService.get(), this$0.failureHandler, this$0.threadContext, action, transportRequest), null, fallbackToAnonymous, listener);
        }

        Authenticator(String action, TransportRequest transportRequest, User fallbackUser, ActionListener<Authentication> listener) {
            this(new AuditableTransportRequest(this$0.auditTrailService.get(), this$0.failureHandler, this$0.threadContext, action, transportRequest), Objects.requireNonNull(fallbackUser, "Fallback user cannot be null"), false, listener);
        }

        private Authenticator(AuditableRequest auditableRequest, User fallbackUser, boolean fallbackToAnonymous, ActionListener<Authentication> listener) {
            this.request = auditableRequest;
            this.fallbackUser = fallbackUser;
            this.fallbackToAnonymous = fallbackToAnonymous;
            this.defaultOrderedRealmList = AuthenticationService.this.realms.getActiveRealms();
            this.listener = listener;
        }

        private void authenticateAsync() {
            if (this.defaultOrderedRealmList.isEmpty()) {
                logger.debug("No realms available, failing authentication");
                this.listener.onResponse(null);
            } else {
                Authentication authentication;
                try {
                    authentication = this.lookForExistingAuthentication();
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                    return;
                }
                if (authentication != null) {
                    logger.trace("Found existing authentication [{}] in request [{}]", (Object)authentication, (Object)this.request);
                    this.listener.onResponse((Object)authentication);
                } else {
                    this.checkForBearerToken();
                }
            }
        }

        private void checkForBearerToken() {
            SecureString bearerString = AuthenticationService.this.tokenService.extractBearerTokenFromHeader(AuthenticationService.this.threadContext);
            ServiceAccountToken serviceAccountToken = ServiceAccountService.tryParseToken(bearerString);
            if (serviceAccountToken != null) {
                AuthenticationService.this.serviceAccountService.authenticateToken(serviceAccountToken, AuthenticationService.this.nodeName, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                    assert (authentication != null) : "service account authenticate should return either authentication or call onFailure";
                    this.authenticatedBy = authentication.getAuthenticatedBy();
                    this.writeAuthToContext((Authentication)authentication);
                }, e -> {
                    logger.debug((Message)new ParameterizedMessage("Failed to validate service account token for request [{}]", (Object)this.request), (Throwable)e);
                    this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest((Exception)e, serviceAccountToken)));
                }));
            } else {
                AuthenticationService.this.tokenService.tryAuthenticateToken(bearerString, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
                    if (userToken != null) {
                        this.writeAuthToContext(userToken.getAuthentication());
                    } else {
                        this.checkForApiKey();
                    }
                }, e -> {
                    logger.debug((Message)new ParameterizedMessage("Failed to validate token authentication for request [{}]", (Object)this.request), (Throwable)e);
                    if (e instanceof ElasticsearchSecurityException && !AuthenticationService.this.tokenService.isExpiredTokenException((ElasticsearchSecurityException)((Object)((Object)e)))) {
                        this.request.tamperedRequest();
                    }
                    this.listener.onFailure(e);
                }));
            }
        }

        private void checkForApiKey() {
            AuthenticationService.this.apiKeyService.authenticateWithApiKeyIfPresent(AuthenticationService.this.threadContext, (ActionListener<AuthenticationResult>)ActionListener.wrap(authResult -> {
                if (authResult.isAuthenticated()) {
                    Authentication authentication = AuthenticationService.this.apiKeyService.createApiKeyAuthentication((AuthenticationResult)authResult, AuthenticationService.this.nodeName);
                    this.authenticatedBy = authentication.getAuthenticatedBy();
                    this.writeAuthToContext(authentication);
                } else if (authResult.getStatus() == AuthenticationResult.Status.TERMINATE) {
                    Exception e = authResult.getException() != null ? authResult.getException() : Exceptions.authenticationError((String)authResult.getMessage(), (Object[])new Object[0]);
                    logger.debug((Message)new ParameterizedMessage("API key service terminated authentication for request [{}]", (Object)this.request), (Throwable)e);
                    this.listener.onFailure(e);
                } else {
                    AuthenticationToken token;
                    if (authResult.getMessage() != null) {
                        if (authResult.getException() != null) {
                            logger.warn((Message)new ParameterizedMessage("Authentication using apikey failed - {}", (Object)authResult.getMessage()), (Throwable)authResult.getException());
                        } else {
                            logger.warn("Authentication using apikey failed - {}", (Object)authResult.getMessage());
                        }
                    }
                    try {
                        token = this.extractToken();
                    }
                    catch (Exception e) {
                        this.listener.onFailure(e);
                        return;
                    }
                    this.consumeToken(token);
                }
            }, e -> this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest((Exception)e, null)))));
        }

        private Authentication lookForExistingAuthentication() {
            Authentication authentication;
            try {
                authentication = AuthenticationService.this.authenticationSerializer.readFromContext(AuthenticationService.this.threadContext);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("caught exception while trying to read authentication from request [{}]", (Object)this.request), (Throwable)e);
                throw this.request.tamperedRequest();
            }
            if (authentication != null && this.request instanceof AuditableRestRequest) {
                throw this.request.tamperedRequest();
            }
            return authentication;
        }

        AuthenticationToken extractToken() {
            try {
                if (this.authenticationToken != null) {
                    return this.authenticationToken;
                }
                for (Realm realm : this.defaultOrderedRealmList) {
                    AuthenticationToken token = realm.token(AuthenticationService.this.threadContext);
                    if (token == null) continue;
                    logger.trace("Found authentication credentials [{}] for principal [{}] in request [{}]", (Object)token.getClass().getName(), (Object)token.principal(), (Object)this.request);
                    return token;
                }
            }
            catch (Exception e) {
                logger.warn("An exception occurred while attempting to find authentication credentials", (Throwable)e);
                throw this.request.exceptionProcessingRequest(e, null);
            }
            return null;
        }

        private void consumeToken(AuthenticationToken token) {
            if (token == null) {
                this.handleNullToken();
            } else {
                this.authenticationToken = token;
                List<Realm> realmsList = this.getRealmList(this.authenticationToken.principal());
                logger.trace("Checking token of type [{}] against [{}] realm(s)", (Object)token.getClass().getName(), (Object)realmsList.size());
                long startInvalidation = AuthenticationService.this.numInvalidation.get();
                LinkedHashMap messages = new LinkedHashMap();
                BiConsumer<Realm, ActionListener> realmAuthenticatingConsumer = (realm, userListener) -> {
                    if (realm.supports(this.authenticationToken)) {
                        logger.trace("Trying to authenticate [{}] using realm [{}] with token [{}] ", (Object)token.principal(), realm, (Object)token.getClass().getName());
                        realm.authenticate(this.authenticationToken, ActionListener.wrap(result -> {
                            assert (result != null) : "Realm " + realm + " produced a null authentication result";
                            logger.debug("Authentication of [{}] using realm [{}] with token [{}] was [{}]", (Object)token.principal(), realm, (Object)token.getClass().getSimpleName(), result);
                            if (result.getStatus() == AuthenticationResult.Status.SUCCESS) {
                                this.authenticatedBy = new Authentication.RealmRef(realm.name(), realm.type(), AuthenticationService.this.nodeName);
                                this.authenticationResult = result;
                                if (AuthenticationService.this.lastSuccessfulAuthCache != null && startInvalidation == AuthenticationService.this.numInvalidation.get()) {
                                    AuthenticationService.this.lastSuccessfulAuthCache.put((Object)this.authenticationToken.principal(), realm);
                                }
                                userListener.onResponse((Object)result.getUser());
                            } else {
                                this.request.realmAuthenticationFailed(this.authenticationToken, realm.name());
                                if (result.getStatus() == AuthenticationResult.Status.TERMINATE) {
                                    if (result.getException() != null) {
                                        logger.info((Message)new ParameterizedMessage("Authentication of [{}] was terminated by realm [{}] - {}", new Object[]{this.authenticationToken.principal(), realm.name(), result.getMessage()}), (Throwable)result.getException());
                                    } else {
                                        logger.info("Authentication of [{}] was terminated by realm [{}] - {}", (Object)this.authenticationToken.principal(), (Object)realm.name(), (Object)result.getMessage());
                                    }
                                    userListener.onFailure(result.getException());
                                } else {
                                    if (result.getMessage() != null) {
                                        messages.put(realm, new Tuple((Object)result.getMessage(), (Object)result.getException()));
                                    }
                                    userListener.onResponse(null);
                                }
                            }
                        }, ex -> {
                            logger.warn((Message)new ParameterizedMessage("An error occurred while attempting to authenticate [{}] against realm [{}]", (Object)this.authenticationToken.principal(), (Object)realm.name()), (Throwable)ex);
                            userListener.onFailure(ex);
                        }));
                    } else {
                        userListener.onResponse(null);
                    }
                };
                IteratingActionListener authenticatingListener = new IteratingActionListener((ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(user -> this.consumeUser((User)user, messages), e -> {
                    if (e != null) {
                        this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest((Exception)e, token)));
                    } else {
                        this.listener.onFailure((Exception)((Object)this.request.authenticationFailed(token)));
                    }
                }), (ThreadContext)AuthenticationService.this.threadContext), realmAuthenticatingConsumer, realmsList, AuthenticationService.this.threadContext);
                try {
                    authenticatingListener.run();
                }
                catch (Exception e2) {
                    logger.debug((Message)new ParameterizedMessage("Authentication of [{}] with token [{}] failed", (Object)token.principal(), (Object)token.getClass().getName()), (Throwable)e2);
                    this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest(e2, token)));
                }
            }
        }

        private List<Realm> getRealmList(String principal) {
            int index;
            Realm lastSuccess;
            List<Realm> orderedRealmList = this.defaultOrderedRealmList;
            if (AuthenticationService.this.lastSuccessfulAuthCache != null && (lastSuccess = (Realm)AuthenticationService.this.lastSuccessfulAuthCache.get((Object)principal)) != null && (index = orderedRealmList.indexOf(lastSuccess)) > 0) {
                ArrayList<Realm> smartOrder = new ArrayList<Realm>(orderedRealmList.size());
                smartOrder.add(lastSuccess);
                for (int i = 0; i < orderedRealmList.size(); ++i) {
                    if (i == index) continue;
                    smartOrder.add(orderedRealmList.get(i));
                }
                assert (smartOrder.size() == orderedRealmList.size() && smartOrder.containsAll(orderedRealmList)) : "Element mismatch between SmartOrder=" + smartOrder + " and DefaultOrder=" + orderedRealmList;
                return Collections.unmodifiableList(smartOrder);
            }
            return orderedRealmList;
        }

        void handleNullToken() {
            Authentication authentication;
            List<Realm> unlicensedRealms = AuthenticationService.this.realms.getUnlicensedRealms();
            if (!unlicensedRealms.isEmpty()) {
                logger.warn("No authentication credential could be extracted using realms [{}]. Realms [{}] were skipped because they are not permitted on the current license", (Object)Strings.collectionToCommaDelimitedString(this.defaultOrderedRealmList), (Object)Strings.collectionToCommaDelimitedString(unlicensedRealms));
            }
            if (this.fallbackUser != null) {
                logger.trace("No valid credentials found in request [{}], using fallback [{}]", (Object)this.request, (Object)this.fallbackUser.principal());
                Authentication.RealmRef authenticatedBy = new Authentication.RealmRef("__fallback", "__fallback", AuthenticationService.this.nodeName);
                authentication = new Authentication(this.fallbackUser, authenticatedBy, null, Version.CURRENT, Authentication.AuthenticationType.INTERNAL, Collections.emptyMap());
            } else if (this.fallbackToAnonymous) {
                logger.trace("No valid credentials found in request [{}], using anonymous [{}]", (Object)this.request, (Object)AuthenticationService.this.anonymousUser.principal());
                Authentication.RealmRef authenticatedBy = new Authentication.RealmRef("__anonymous", "__anonymous", AuthenticationService.this.nodeName);
                authentication = new Authentication((User)AuthenticationService.this.anonymousUser, authenticatedBy, null, Version.CURRENT, Authentication.AuthenticationType.ANONYMOUS, Collections.emptyMap());
            } else {
                authentication = null;
            }
            if (authentication != null) {
                this.writeAuthToContext(authentication);
            } else {
                logger.debug("No valid credentials found in request [{}], rejecting", (Object)this.request);
                this.listener.onFailure((Exception)((Object)this.request.anonymousAccessDenied()));
            }
        }

        private void consumeUser(User user, Map<Realm, Tuple<String, Exception>> messages) {
            if (user == null) {
                messages.forEach((realm, tuple) -> {
                    String message = (String)tuple.v1();
                    String cause = tuple.v2() == null ? "" : " (Caused by " + tuple.v2() + ")";
                    logger.warn("Authentication to realm {} failed - {}{}", (Object)realm.name(), (Object)message, (Object)cause);
                });
                List<Realm> unlicensedRealms = AuthenticationService.this.realms.getUnlicensedRealms();
                if (!unlicensedRealms.isEmpty()) {
                    logger.warn("Authentication failed using realms [{}]. Realms [{}] were skipped because they are not permitted on the current license", (Object)Strings.collectionToCommaDelimitedString(this.defaultOrderedRealmList), (Object)Strings.collectionToCommaDelimitedString(unlicensedRealms));
                }
                logger.trace("Failed to authenticate request [{}]", (Object)this.request);
                this.listener.onFailure((Exception)((Object)this.request.authenticationFailed(this.authenticationToken)));
            } else {
                AuthenticationService.this.threadContext.putTransient(AuthenticationResult.THREAD_CONTEXT_KEY, (Object)this.authenticationResult);
                if (AuthenticationService.this.runAsEnabled) {
                    String runAsUsername = AuthenticationService.this.threadContext.getHeader("es-security-runas-user");
                    if (runAsUsername != null && !runAsUsername.isEmpty()) {
                        this.lookupRunAsUser(user, runAsUsername, this::finishAuthentication);
                    } else if (runAsUsername == null) {
                        this.finishAuthentication(user);
                    } else {
                        assert (runAsUsername.isEmpty()) : "the run as username may not be empty";
                        logger.debug("user [{}] attempted to runAs with an empty username", (Object)user.principal());
                        this.listener.onFailure((Exception)((Object)this.request.runAsDenied(new Authentication(new User(runAsUsername, null, user), this.authenticatedBy, this.lookedupBy), this.authenticationToken)));
                    }
                } else {
                    this.finishAuthentication(user);
                }
            }
        }

        private void lookupRunAsUser(User user, String runAsUsername, Consumer<User> userConsumer) {
            logger.trace("Looking up run-as user [{}] for authenticated user [{}]", (Object)runAsUsername, (Object)user.principal());
            RealmUserLookup lookup = new RealmUserLookup(this.getRealmList(runAsUsername), AuthenticationService.this.threadContext);
            long startInvalidationNum = AuthenticationService.this.numInvalidation.get();
            lookup.lookup(runAsUsername, (ActionListener<Tuple<User, Realm>>)ActionListener.wrap(tuple -> {
                if (tuple == null) {
                    logger.debug("Cannot find run-as user [{}] for authenticated user [{}]", (Object)runAsUsername, (Object)user.principal());
                    userConsumer.accept(new User(runAsUsername, null, user));
                } else {
                    User foundUser = Objects.requireNonNull((User)tuple.v1());
                    Realm realm = Objects.requireNonNull((Realm)tuple.v2());
                    this.lookedupBy = new Authentication.RealmRef(realm.name(), realm.type(), AuthenticationService.this.nodeName);
                    if (AuthenticationService.this.lastSuccessfulAuthCache != null && startInvalidationNum == AuthenticationService.this.numInvalidation.get()) {
                        AuthenticationService.this.lastSuccessfulAuthCache.computeIfAbsent((Object)runAsUsername, s -> realm);
                    }
                    logger.trace("Using run-as user [{}] with authenticated user [{}]", (Object)foundUser, (Object)user.principal());
                    userConsumer.accept(new User(foundUser, user));
                }
            }, exception -> this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest((Exception)exception, this.authenticationToken)))));
        }

        void finishAuthentication(User finalUser) {
            if (!finalUser.enabled() || !finalUser.authenticatedUser().enabled()) {
                logger.debug("user [{}] is disabled. failing authentication", (Object)finalUser);
                this.listener.onFailure((Exception)((Object)this.request.authenticationFailed(this.authenticationToken)));
            } else {
                Authentication finalAuth = new Authentication(finalUser, this.authenticatedBy, this.lookedupBy);
                this.writeAuthToContext(finalAuth);
            }
        }

        void writeAuthToContext(Authentication authentication) {
            try {
                AuthenticationService.this.authenticationSerializer.writeToContext(authentication, AuthenticationService.this.threadContext);
                this.request.authenticationSuccess(authentication);
                AuthenticationService.this.operatorPrivilegesService.maybeMarkOperatorUser(authentication, AuthenticationService.this.threadContext);
            }
            catch (Exception e) {
                logger.debug((Message)new ParameterizedMessage("Failed to store authentication [{}] for request [{}]", (Object)authentication, (Object)this.request), (Throwable)e);
                this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest(e, this.authenticationToken)));
                return;
            }
            logger.trace("Established authentication [{}] for request [{}]", (Object)authentication, (Object)this.request);
            this.listener.onResponse((Object)authentication);
        }
    }

    static class AuditableRestRequest
    extends AuditableRequest {
        private final RestRequest request;
        private final String requestId;

        AuditableRestRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext, RestRequest request) {
            super(auditTrail, failureHandler, threadContext);
            this.request = request;
            this.requestId = AuditUtil.generateRequestId(threadContext);
        }

        @Override
        void authenticationSuccess(Authentication authentication) {
            this.auditTrail.authenticationSuccess(this.requestId, authentication, this.request);
        }

        @Override
        void realmAuthenticationFailed(AuthenticationToken token, String realm) {
            this.auditTrail.authenticationFailed(this.requestId, realm, token, this.request);
        }

        @Override
        ElasticsearchSecurityException tamperedRequest() {
            this.auditTrail.tamperedRequest(this.requestId, this.request);
            return new ElasticsearchSecurityException("rest request attempted to inject a user", new Object[0]);
        }

        @Override
        ElasticsearchSecurityException exceptionProcessingRequest(Exception e, @Nullable AuthenticationToken token) {
            if (token != null) {
                this.auditTrail.authenticationFailed(this.requestId, token, this.request);
            } else {
                this.auditTrail.authenticationFailed(this.requestId, this.request);
            }
            return this.failureHandler.exceptionProcessingRequest(this.request, e, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException authenticationFailed(AuthenticationToken token) {
            this.auditTrail.authenticationFailed(this.requestId, token, this.request);
            return this.failureHandler.failedAuthentication(this.request, token, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException anonymousAccessDenied() {
            this.auditTrail.anonymousAccessDenied(this.requestId, this.request);
            return this.failureHandler.missingToken(this.request, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException runAsDenied(Authentication authentication, AuthenticationToken token) {
            this.auditTrail.runAsDenied(this.requestId, authentication, this.request, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
            return this.failureHandler.failedAuthentication(this.request, token, this.threadContext);
        }

        public String toString() {
            return "rest request uri [" + this.request.uri() + "]";
        }
    }

    static class AuditableTransportRequest
    extends AuditableRequest {
        private final String action;
        private final TransportRequest transportRequest;
        private final String requestId;

        AuditableTransportRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext, String action, TransportRequest transportRequest) {
            super(auditTrail, failureHandler, threadContext);
            this.action = action;
            this.transportRequest = transportRequest;
            this.requestId = AuditUtil.getOrGenerateRequestId(threadContext);
        }

        @Override
        void authenticationSuccess(Authentication authentication) {
            this.auditTrail.authenticationSuccess(this.requestId, authentication, this.action, this.transportRequest);
        }

        @Override
        void realmAuthenticationFailed(AuthenticationToken token, String realm) {
            this.auditTrail.authenticationFailed(this.requestId, realm, token, this.action, this.transportRequest);
        }

        @Override
        ElasticsearchSecurityException tamperedRequest() {
            this.auditTrail.tamperedRequest(this.requestId, this.action, this.transportRequest);
            return new ElasticsearchSecurityException("failed to verify signed authentication information", new Object[0]);
        }

        @Override
        ElasticsearchSecurityException exceptionProcessingRequest(Exception e, @Nullable AuthenticationToken token) {
            if (token != null) {
                this.auditTrail.authenticationFailed(this.requestId, token, this.action, this.transportRequest);
            } else {
                this.auditTrail.authenticationFailed(this.requestId, this.action, this.transportRequest);
            }
            return this.failureHandler.exceptionProcessingRequest((TransportMessage)this.transportRequest, this.action, e, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException authenticationFailed(AuthenticationToken token) {
            this.auditTrail.authenticationFailed(this.requestId, token, this.action, this.transportRequest);
            return this.failureHandler.failedAuthentication((TransportMessage)this.transportRequest, token, this.action, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException anonymousAccessDenied() {
            this.auditTrail.anonymousAccessDenied(this.requestId, this.action, this.transportRequest);
            return this.failureHandler.missingToken((TransportMessage)this.transportRequest, this.action, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException runAsDenied(Authentication authentication, AuthenticationToken token) {
            this.auditTrail.runAsDenied(this.requestId, authentication, this.action, this.transportRequest, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
            return this.failureHandler.failedAuthentication((TransportMessage)this.transportRequest, token, this.action, this.threadContext);
        }

        public String toString() {
            return "transport request action [" + this.action + "]";
        }
    }

    static abstract class AuditableRequest {
        final AuditTrail auditTrail;
        final AuthenticationFailureHandler failureHandler;
        final ThreadContext threadContext;

        AuditableRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext) {
            this.auditTrail = auditTrail;
            this.failureHandler = failureHandler;
            this.threadContext = threadContext;
        }

        abstract void realmAuthenticationFailed(AuthenticationToken var1, String var2);

        abstract ElasticsearchSecurityException tamperedRequest();

        abstract ElasticsearchSecurityException exceptionProcessingRequest(Exception var1, @Nullable AuthenticationToken var2);

        abstract ElasticsearchSecurityException authenticationFailed(AuthenticationToken var1);

        abstract ElasticsearchSecurityException anonymousAccessDenied();

        abstract ElasticsearchSecurityException runAsDenied(Authentication var1, AuthenticationToken var2);

        abstract void authenticationSuccess(Authentication var1);
    }
}

