/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.oidc;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectAuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectAuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectToken;

public class TransportOpenIdConnectAuthenticateAction
extends HandledTransportAction<OpenIdConnectAuthenticateRequest, OpenIdConnectAuthenticateResponse> {
    private final ThreadPool threadPool;
    private final AuthenticationService authenticationService;
    private final TokenService tokenService;
    private final SecurityContext securityContext;
    private static final Logger logger = LogManager.getLogger(TransportOpenIdConnectAuthenticateAction.class);

    @Inject
    public TransportOpenIdConnectAuthenticateAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthenticationService authenticationService, TokenService tokenService, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/oidc/authenticate", transportService, actionFilters, OpenIdConnectAuthenticateRequest::new);
        this.threadPool = threadPool;
        this.authenticationService = authenticationService;
        this.tokenService = tokenService;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, OpenIdConnectAuthenticateRequest request, ActionListener<OpenIdConnectAuthenticateResponse> listener) {
        OpenIdConnectToken token = new OpenIdConnectToken(request.getRedirectUri(), new State(request.getState()), new Nonce(request.getNonce()), request.getRealm());
        ThreadContext threadContext = this.threadPool.getThreadContext();
        Authentication originatingAuthentication = this.securityContext.getAuthentication();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.authenticationService.authenticate("cluster:admin/xpack/security/oidc/authenticate", (TransportRequest)request, token, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                AuthenticationResult result = (AuthenticationResult)threadContext.getTransient(AuthenticationResult.THREAD_CONTEXT_KEY);
                if (result == null) {
                    listener.onFailure((Exception)new IllegalStateException("Cannot find AuthenticationResult on thread context"));
                    return;
                }
                Map tokenMetadata = (Map)result.getMetadata().get("_oidc_tokendata");
                this.tokenService.createOAuth2Tokens((Authentication)authentication, originatingAuthentication, tokenMetadata, true, (ActionListener<TokenService.CreateTokenResult>)ActionListener.wrap(tokenResult -> {
                    TimeValue expiresIn = this.tokenService.getExpirationDelay();
                    listener.onResponse((Object)new OpenIdConnectAuthenticateResponse(authentication, tokenResult.getAccessToken(), tokenResult.getRefreshToken(), expiresIn));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, e -> {
                logger.debug(() -> new ParameterizedMessage("OpenIDConnectToken [{}] could not be authenticated", (Object)token), (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }
}

