/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityFeatureSetUsage;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;

public class SecurityFeatureSet
implements XPackFeatureSet {
    private final Settings settings;
    private final XPackLicenseState licenseState;
    @Nullable
    private final Realms realms;
    @Nullable
    private final CompositeRolesStore rolesStore;
    @Nullable
    private final NativeRoleMappingStore roleMappingStore;
    @Nullable
    private final IPFilter ipFilter;

    @Inject
    public SecurityFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, @Nullable Realms realms, @Nullable CompositeRolesStore rolesStore, @Nullable NativeRoleMappingStore roleMappingStore, @Nullable IPFilter ipFilter) {
        this.licenseState = licenseState;
        this.realms = realms;
        this.rolesStore = rolesStore;
        this.roleMappingStore = roleMappingStore;
        this.settings = settings;
        this.ipFilter = ipFilter;
    }

    public String name() {
        return "security";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return this.licenseState != null && this.licenseState.isSecurityEnabled();
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        Map<String, Object> sslUsage = SecurityFeatureSet.sslUsage(this.settings);
        Map<String, Object> tokenServiceUsage = SecurityFeatureSet.tokenServiceUsage(this.settings);
        Map<String, Object> apiKeyServiceUsage = SecurityFeatureSet.apiKeyServiceUsage(this.settings);
        Map<String, Object> auditUsage = SecurityFeatureSet.auditUsage(this.settings);
        Map<String, Object> ipFilterUsage = SecurityFeatureSet.ipFilterUsage(this.ipFilter);
        Map<String, Boolean> anonymousUsage = Collections.singletonMap("enabled", AnonymousUser.isAnonymousEnabled((Settings)this.settings));
        Map<String, Object> fips140Usage = SecurityFeatureSet.fips140Usage(this.settings);
        Map operatorPrivilegesUsage = org.elasticsearch.core.Map.of((Object)"available", (Object)this.licenseState.isAllowed(XPackLicenseState.Feature.OPERATOR_PRIVILEGES), (Object)"enabled", (Object)OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED.get(this.settings));
        AtomicReference rolesUsageRef = new AtomicReference();
        AtomicReference roleMappingUsageRef = new AtomicReference();
        AtomicReference realmsUsageRef = new AtomicReference();
        boolean enabled = this.licenseState.isSecurityEnabled();
        CountDown countDown = new CountDown(3);
        Runnable doCountDown = () -> {
            if (countDown.countDown()) {
                listener.onResponse((Object)new SecurityFeatureSetUsage(this.enabled(), (Map)realmsUsageRef.get(), (Map)rolesUsageRef.get(), (Map)roleMappingUsageRef.get(), sslUsage, auditUsage, ipFilterUsage, anonymousUsage, tokenServiceUsage, apiKeyServiceUsage, fips140Usage, operatorPrivilegesUsage));
            }
        };
        ActionListener rolesStoreUsageListener = ActionListener.wrap(rolesStoreUsage -> {
            rolesUsageRef.set(rolesStoreUsage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener roleMappingStoreUsageListener = ActionListener.wrap(nativeRoleMappingStoreUsage -> {
            Map<String, Map> usage = Collections.singletonMap("native", nativeRoleMappingStoreUsage);
            roleMappingUsageRef.set(usage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener realmsUsageListener = ActionListener.wrap(realmsUsage -> {
            realmsUsageRef.set(realmsUsage);
            doCountDown.run();
        }, arg_0 -> listener.onFailure(arg_0));
        if (this.rolesStore == null || !enabled) {
            rolesStoreUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.rolesStore.usageStats((ActionListener<Map<String, Object>>)rolesStoreUsageListener);
        }
        if (this.roleMappingStore == null || !enabled) {
            roleMappingStoreUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.roleMappingStore.usageStats((ActionListener<Map<String, Object>>)roleMappingStoreUsageListener);
        }
        if (this.realms == null || !enabled) {
            realmsUsageListener.onResponse(Collections.emptyMap());
        } else {
            this.realms.usageStats((ActionListener<Map<String, Object>>)realmsUsageListener);
        }
    }

    static Map<String, Object> sslUsage(Settings settings) {
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("http", Collections.singletonMap("enabled", (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings)));
            map.put("transport", Collections.singletonMap("enabled", (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)));
            return map;
        }
        return Collections.emptyMap();
    }

    static Map<String, Object> tokenServiceUsage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings));
    }

    static Map<String, Object> apiKeyServiceUsage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.get(settings));
    }

    static Map<String, Object> auditUsage(Settings settings) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("enabled", XPackSettings.AUDIT_ENABLED.get(settings));
        if (((Boolean)XPackSettings.AUDIT_ENABLED.get(settings)).booleanValue()) {
            map.put("outputs", Arrays.asList("logfile"));
        }
        return map;
    }

    static Map<String, Object> ipFilterUsage(@Nullable IPFilter ipFilter) {
        if (ipFilter == null) {
            return IPFilter.DISABLED_USAGE_STATS;
        }
        return ipFilter.usageStats();
    }

    static Map<String, Object> fips140Usage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.FIPS_MODE_ENABLED.get(settings));
    }
}

