/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.multiterms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.multiterms.MultiTermsAggregationBuilder;
import org.elasticsearch.xpack.analytics.multiterms.MultiTermsAggregator;

public class MultiTermsAggregationFactory
extends AggregatorFactory {
    protected final List<ValuesSourceConfig> configs;
    protected final List<DocValueFormat> formats;
    private final boolean showTermDocCountError;
    private final BucketOrder order;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;

    public MultiTermsAggregationFactory(String name, List<ValuesSourceConfig> configs, List<DocValueFormat> formats, boolean showTermDocCountError, BucketOrder order, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.configs = configs;
        this.formats = formats;
        this.showTermDocCountError = showTermDocCountError;
        this.order = order;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
    }

    protected Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (!InternalOrder.isKeyOrder((BucketOrder)this.order) && bucketCountThresholds.getShardSize() == MultiTermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize((int)bucketCountThresholds.getRequiredSize()));
        }
        bucketCountThresholds.ensureValidity();
        return new MultiTermsAggregator(this.name, this.factories, this.context, parent, this.configs, this.formats, this.showTermDocCountError, this.order, this.collectMode, bucketCountThresholds, cardinality, metadata);
    }
}

