/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.cleaner;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractLifecycleRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;

public class CleanerService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(CleanerService.class);
    private final XPackLicenseState licenseState;
    private final ThreadPool threadPool;
    private final ExecutionScheduler executionScheduler;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final IndicesCleaner runnable;
    private volatile TimeValue globalRetention;

    CleanerService(Settings settings, ClusterSettings clusterSettings, XPackLicenseState licenseState, ThreadPool threadPool, ExecutionScheduler executionScheduler) {
        this.licenseState = licenseState;
        this.threadPool = threadPool;
        this.executionScheduler = executionScheduler;
        this.globalRetention = (TimeValue)MonitoringField.HISTORY_DURATION.get(settings);
        this.runnable = new IndicesCleaner();
        clusterSettings.addSettingsUpdateConsumer(MonitoringField.HISTORY_DURATION, this::setGlobalRetention);
    }

    public CleanerService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, XPackLicenseState licenseState) {
        this(settings, clusterSettings, licenseState, threadPool, new DefaultExecutionScheduler());
    }

    protected void doStart() {
        logger.debug("starting cleaning service");
        this.threadPool.schedule((Runnable)((Object)this.runnable), this.executionScheduler.nextExecutionDelay(ZonedDateTime.now(Clock.systemDefaultZone())), this.executorName());
        logger.debug("cleaning service started");
    }

    protected void doStop() {
        logger.debug("stopping cleaning service");
        this.listeners.clear();
        logger.debug("cleaning service stopped");
    }

    protected void doClose() {
        logger.debug("closing cleaning service");
        this.runnable.cancel();
        logger.debug("cleaning service closed");
    }

    private String executorName() {
        return "generic";
    }

    public TimeValue getRetention() {
        if (this.licenseState.checkFeature(XPackLicenseState.Feature.MONITORING_UPDATE_RETENTION) && this.globalRetention != null) {
            return this.globalRetention;
        }
        return (TimeValue)MonitoringField.HISTORY_DURATION.getDefault(Settings.EMPTY);
    }

    public void setGlobalRetention(TimeValue globalRetention) {
        if (!this.licenseState.checkFeature(XPackLicenseState.Feature.MONITORING_UPDATE_RETENTION)) {
            logger.warn("[{}] setting will be ignored until an appropriate license is applied", (Object)MonitoringField.HISTORY_DURATION.getKey());
        }
        this.globalRetention = globalRetention;
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    static interface ExecutionScheduler {
        public TimeValue nextExecutionDelay(ZonedDateTime var1);
    }

    class IndicesCleaner
    extends AbstractLifecycleRunnable {
        private volatile Scheduler.Cancellable cancellable;

        IndicesCleaner() {
            super(CleanerService.this.lifecycle, logger);
        }

        protected void doRunInLifecycle() throws Exception {
            TimeValue retention = CleanerService.this.getRetention();
            logger.trace("cleaning up indices with retention [{}]", (Object)retention);
            for (Listener listener : CleanerService.this.listeners) {
                try {
                    listener.onCleanUpIndices(retention);
                }
                catch (Exception e) {
                    logger.error("listener failed to clean indices", (Throwable)e);
                }
            }
            logger.trace("done cleaning up indices");
        }

        protected void onAfterInLifecycle() {
            ZonedDateTime start = ZonedDateTime.now(Clock.systemUTC());
            TimeValue delay = CleanerService.this.executionScheduler.nextExecutionDelay(start);
            logger.debug("scheduling next execution in [{}] seconds", (Object)delay.seconds());
            try {
                this.cancellable = CleanerService.this.threadPool.schedule((Runnable)((Object)this), delay, CleanerService.this.executorName());
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug("couldn't schedule new execution of the cleaner, executor is shutting down", (Throwable)e);
                }
                throw e;
            }
        }

        public void onFailure(Exception e) {
            logger.error("failed to clean indices", (Throwable)e);
        }

        public void cancel() {
            if (this.cancellable != null && !this.cancellable.isCancelled()) {
                this.cancellable.cancel();
            }
        }
    }

    static class DefaultExecutionScheduler
    implements ExecutionScheduler {
        DefaultExecutionScheduler() {
        }

        @Override
        public TimeValue nextExecutionDelay(ZonedDateTime now) {
            ZonedDateTime next = now.toLocalDate().atStartOfDay(now.getZone()).plusHours(1L);
            if (!next.isAfter(now)) {
                next = next.plusDays(1L);
            }
            return TimeValue.timeValueMillis((long)Duration.between(now, next).toMillis());
        }
    }

    public static interface Listener {
        public void onCleanUpIndices(TimeValue var1);
    }
}

