/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.wildcard.mapper;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;

public class BinaryDvConfirmedAutomatonQuery
extends Query {
    private final String field;
    private final String matchPattern;
    private final ByteRunAutomaton bytesMatcher;
    private final Query approxQuery;

    public BinaryDvConfirmedAutomatonQuery(Query approximation, String field, String matchPattern, Automaton automaton) {
        this.approxQuery = approximation;
        this.field = field;
        this.matchPattern = matchPattern;
        this.bytesMatcher = new ByteRunAutomaton(automaton);
    }

    private BinaryDvConfirmedAutomatonQuery(Query approximation, String field, String matchPattern, ByteRunAutomaton bytesMatcher) {
        this.approxQuery = approximation;
        this.field = field;
        this.matchPattern = matchPattern;
        this.bytesMatcher = bytesMatcher;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query approxRewrite = this.approxQuery.rewrite(reader);
        if (this.approxQuery != approxRewrite) {
            return new BinaryDvConfirmedAutomatonQuery(approxRewrite, this.field, this.matchPattern, this.bytesMatcher);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight approxWeight = this.approxQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final ByteArrayDataInput badi = new ByteArrayDataInput();
                final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)BinaryDvConfirmedAutomatonQuery.this.field);
                Scorer approxScorer = approxWeight.scorer(context);
                if (approxScorer == null) {
                    return null;
                }
                final DocIdSetIterator approxDisi = approxScorer.iterator();
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approxDisi){

                    public boolean matches() throws IOException {
                        if (!values.advanceExact(approxDisi.docID())) {
                            assert (BinaryDvConfirmedAutomatonQuery.this.approxQuery instanceof MatchAllDocsQuery);
                            return false;
                        }
                        BytesRef arrayOfValues = values.binaryValue();
                        badi.reset(arrayOfValues.bytes);
                        badi.setPosition(arrayOfValues.offset);
                        int size = badi.readVInt();
                        for (int i = 0; i < size; ++i) {
                            int valLength = badi.readVInt();
                            if (BinaryDvConfirmedAutomatonQuery.this.bytesMatcher.run(arrayOfValues.bytes, badi.getPosition(), valLength)) {
                                return true;
                            }
                            badi.skipBytes((long)valLength);
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String toString(String field) {
        return field + ":" + this.matchPattern;
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BinaryDvConfirmedAutomatonQuery other = (BinaryDvConfirmedAutomatonQuery)((Object)obj);
        return Objects.equals(this.field, other.field) && Objects.equals(this.matchPattern, other.matchPattern) && Objects.equals(this.bytesMatcher, other.bytesMatcher) && Objects.equals(this.approxQuery, other.approxQuery);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.matchPattern, this.bytesMatcher, this.approxQuery);
    }

    Query getApproximationQuery() {
        return this.approxQuery;
    }
}

