/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public class SetStepInfoUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(SetStepInfoUpdateTask.class);
    private final Index index;
    private final String policy;
    private final Step.StepKey currentStepKey;
    private final ToXContentObject stepInfo;

    public SetStepInfoUpdateTask(Index index, String policy, Step.StepKey currentStepKey, ToXContentObject stepInfo) {
        this.index = index;
        this.policy = policy;
        this.currentStepKey = currentStepKey;
        this.stepInfo = stepInfo;
    }

    Index getIndex() {
        return this.index;
    }

    String getPolicy() {
        return this.policy;
    }

    Step.StepKey getCurrentStepKey() {
        return this.currentStepKey;
    }

    ToXContentObject getStepInfo() {
        return this.stepInfo;
    }

    public ClusterState execute(ClusterState currentState) throws IOException {
        IndexMetadata idxMeta = currentState.getMetadata().index(this.index);
        if (idxMeta == null) {
            return currentState;
        }
        Settings indexSettings = idxMeta.getSettings();
        LifecycleExecutionState indexILMData = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta);
        if (this.policy.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings)) && Objects.equals(this.currentStepKey, LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)indexILMData))) {
            return IndexLifecycleTransition.addStepInfoToClusterState(this.index, currentState, this.stepInfo);
        }
        return currentState;
    }

    public void onFailure(String source, Exception e) {
        logger.warn((Message)new ParameterizedMessage("policy [{}] for index [{}] failed trying to set step info for step [{}].", new Object[]{this.policy, this.index.getName(), this.currentStepKey}), (Throwable)e);
    }

    public static class ExceptionWrapper
    implements ToXContentObject {
        private final Throwable exception;

        public ExceptionWrapper(Throwable exception) {
            this.exception = exception;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.exception);
            builder.endObject();
            return builder;
        }
    }
}

