/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.TransportDecompressor;

public class Lz4TransportDecompressor
implements TransportDecompressor {
    private static final ThreadLocal<byte[]> DECOMPRESSED = ThreadLocal.withInitial(() -> BytesRef.EMPTY_BYTES);
    private static final ThreadLocal<byte[]> COMPRESSED = ThreadLocal.withInitial(() -> BytesRef.EMPTY_BYTES);
    static final long MAGIC_NUMBER = 5501767354678207339L;
    static final int HEADER_LENGTH = 21;
    static final int COMPRESSION_LEVEL_BASE = 10;
    static final int MIN_BLOCK_SIZE = 64;
    static final int MAX_BLOCK_SIZE = 0x2000000;
    static final int DEFAULT_BLOCK_SIZE = 65536;
    static final int BLOCK_TYPE_NON_COMPRESSED = 16;
    static final int BLOCK_TYPE_COMPRESSED = 32;
    private State currentState = State.INIT_BLOCK;
    private LZ4FastDecompressor decompressor = LZ4Factory.safeInstance().fastDecompressor();
    private Checksum checksum;
    private int blockType;
    private int compressedLength;
    private int decompressedLength;
    private int currentChecksum;
    private final PageCacheRecycler recycler;
    private final ArrayDeque<Recycler.V<byte[]>> pages;
    private int pageOffset = 16384;
    private boolean hasSkippedESHeader = false;

    public Lz4TransportDecompressor(PageCacheRecycler recycler) {
        this.recycler = recycler;
        this.pages = new ArrayDeque(4);
        this.checksum = null;
    }

    @Override
    public ReleasableBytesReference pollDecompressedPage(boolean isEOS) {
        if (this.pages.isEmpty()) {
            return null;
        }
        if (this.pages.size() == 1) {
            if (isEOS) {
                Recycler.V<byte[]> page = this.pages.pollFirst();
                ReleasableBytesReference reference = new ReleasableBytesReference((BytesReference)new BytesArray(page.v(), 0, this.pageOffset), page);
                this.pageOffset = 0;
                return reference;
            }
            return null;
        }
        Recycler.V<byte[]> page = this.pages.pollFirst();
        return new ReleasableBytesReference((BytesReference)new BytesArray(page.v()), page);
    }

    @Override
    public Compression.Scheme getScheme() {
        return Compression.Scheme.LZ4;
    }

    @Override
    public void close() {
        for (Recycler.V<byte[]> page : this.pages) {
            page.close();
        }
    }

    @Override
    public int decompress(BytesReference bytesReference) throws IOException {
        int bytesConsumed = 0;
        if (!this.hasSkippedESHeader) {
            this.hasSkippedESHeader = true;
            int esHeaderLength = 4;
            bytesReference = bytesReference.slice(esHeaderLength, bytesReference.length() - esHeaderLength);
            bytesConsumed += esHeaderLength;
        }
        while (true) {
            int consumed = this.decodeBlock(bytesReference);
            bytesConsumed += consumed;
            int newLength = bytesReference.length() - consumed;
            if (consumed <= 0 || newLength <= 0) break;
            bytesReference = bytesReference.slice(consumed, newLength);
        }
        return bytesConsumed;
    }

    /*
     * Unable to fully structure code
     */
    private int decodeBlock(BytesReference reference) throws IOException {
        bytesConsumed = 0;
        try {
            switch (1.$SwitchMap$org$elasticsearch$transport$Lz4TransportDecompressor$State[this.currentState.ordinal()]) {
                case 1: {
                    if (reference.length() < 21) {
                        return bytesConsumed;
                    }
                    in = reference.streamInput();
                    try {
                        magic = in.readLong();
                        if (magic != 5501767354678207339L) {
                            throw new IllegalStateException("unexpected block identifier");
                        }
                        token = in.readByte();
                        compressionLevel = (token & 15) + 10;
                        blockType = token & 240;
                        compressedLength = Integer.reverseBytes(in.readInt());
                        if (compressedLength < 0 || compressedLength > 0x2000000) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "invalid compressedLength: %d (expected: 0-%d)", new Object[]{compressedLength, 0x2000000}));
                        }
                        decompressedLength = Integer.reverseBytes(in.readInt());
                        maxDecompressedLength = 1 << compressionLevel;
                        if (decompressedLength < 0 || decompressedLength > maxDecompressedLength) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "invalid decompressedLength: %d (expected: 0-%d)", new Object[]{decompressedLength, maxDecompressedLength}));
                        }
                        if (decompressedLength == 0 && compressedLength != 0 || decompressedLength != 0 && compressedLength == 0 || blockType == 16 && decompressedLength != compressedLength) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "stream corrupted: compressedLength(%d) and decompressedLength(%d) mismatch", new Object[]{compressedLength, decompressedLength}));
                        }
                        currentChecksum = Integer.reverseBytes(in.readInt());
                        bytesConsumed += 21;
                        if (decompressedLength == 0) {
                            if (currentChecksum != 0) {
                                throw new IllegalStateException("stream corrupted: checksum error");
                            }
                            this.currentState = State.FINISHED;
                            this.decompressor = null;
                            this.checksum = null;
                            break;
                        }
                        this.blockType = blockType;
                        this.compressedLength = compressedLength;
                        this.decompressedLength = decompressedLength;
                        this.currentChecksum = currentChecksum;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                    this.currentState = State.DECOMPRESS_DATA;
                    break;
                }
                case 2: {
                    if (reference.length() < this.compressedLength) break;
                    checksum = this.checksum;
                    decompressed = this.getThreadLocalBuffer(Lz4TransportDecompressor.DECOMPRESSED, this.decompressedLength);
                    try {
                        switch (this.blockType) {
                            case 16: {
                                streamInput = reference.streamInput();
                                try {
                                    streamInput.readBytes(decompressed, 0, this.decompressedLength);
                                    break;
                                }
                                finally {
                                    if (streamInput != null) {
                                        streamInput.close();
                                    }
                                }
                            }
                            case 32: {
                                ref = reference.iterator().next();
                                if (ref.length < this.compressedLength) ** GOTO lbl65
                                compressed = ref.bytes;
                                compressedOffset = ref.offset;
                                ** GOTO lbl75
lbl65:
                                // 1 sources

                                compressed = this.getThreadLocalBuffer(Lz4TransportDecompressor.COMPRESSED, this.compressedLength);
                                compressedOffset = 0;
                                streamInput = reference.streamInput();
                                try {
                                    streamInput.readBytes(compressed, 0, this.compressedLength);
                                }
                                finally {
                                    if (streamInput != null) {
                                        streamInput.close();
                                    }
                                }
lbl75:
                                // 2 sources

                                this.decompressor.decompress(compressed, compressedOffset, decompressed, 0, this.decompressedLength);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(String.format(Locale.ROOT, "unexpected blockType: %d (expected: %d or %d)", new Object[]{this.blockType, 16, 32}));
                            }
                        }
                        bytesConsumed += this.compressedLength;
                        if (checksum != null) {
                            checksum.reset();
                            checksum.update(decompressed, 0, this.decompressedLength);
                            checksumResult = (int)checksum.getValue();
                            if (checksumResult != this.currentChecksum) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "stream corrupted: mismatching checksum: %d (expected: %d)", new Object[]{checksumResult, this.currentChecksum}));
                            }
                        }
                        bytesToCopy = this.decompressedLength;
                        uncompressedOffset = 0;
                        while (bytesToCopy > 0) {
                            v0 = isNewPage = this.pageOffset == 16384;
                            if (isNewPage) {
                                this.pageOffset = 0;
                                this.pages.add(this.recycler.bytePage(false));
                            }
                            page = this.pages.getLast();
                            toCopy = Math.min(bytesToCopy, 16384 - this.pageOffset);
                            System.arraycopy(decompressed, uncompressedOffset, page.v(), this.pageOffset, toCopy);
                            this.pageOffset += toCopy;
                            bytesToCopy -= toCopy;
                            uncompressedOffset += toCopy;
                        }
                        this.currentState = State.INIT_BLOCK;
                        break;
                    }
                    catch (LZ4Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                case 3: {
                    break;
                }
                case 4: {
                    throw new IllegalStateException("LZ4 stream corrupted.");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IOException e) {
            this.currentState = State.CORRUPTED;
            throw e;
        }
        return bytesConsumed;
    }

    private byte[] getThreadLocalBuffer(ThreadLocal<byte[]> threadLocal, int requiredSize) {
        byte[] buffer = threadLocal.get();
        if (requiredSize > buffer.length) {
            buffer = new byte[requiredSize];
            threadLocal.set(buffer);
        }
        return buffer;
    }

    public boolean isClosed() {
        return this.currentState == State.FINISHED;
    }

    private static enum State {
        INIT_BLOCK,
        DECOMPRESS_DATA,
        FINISHED,
        CORRUPTED;

    }
}

