/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;

public final class NoOpEngine
extends ReadOnlyEngine {
    private final SegmentsStats segmentsStats = new SegmentsStats();
    private final DocsStats docsStats;

    public NoOpEngine(EngineConfig config) {
        super(config, null, null, true, Function.identity(), true, true);
        Directory directory = this.store.directory();
        try (DirectoryReader reader = this.openDirectory(directory, config.getIndexSettings().isSoftDeleteEnabled());){
            for (LeafReaderContext ctx : reader.getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, true, this.segmentsStats);
            }
            this.docsStats = this.docsStats((IndexReader)reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected DirectoryReader open(IndexCommit commit) throws IOException {
        Directory directory = commit.getDirectory();
        List indexCommits = DirectoryReader.listCommits((Directory)directory);
        final IndexCommit indexCommit = (IndexCommit)indexCommits.get(indexCommits.size() - 1);
        return new DirectoryReader(directory, new LeafReader[0], null){

            protected DirectoryReader doOpenIfChanged() {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
                return null;
            }

            public long getVersion() {
                return 0L;
            }

            public boolean isCurrent() {
                return true;
            }

            public IndexCommit getIndexCommit() {
                return indexCommit;
            }

            protected void doClose() {
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    @Override
    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        if (includeUnloadedSegments) {
            SegmentsStats stats = new SegmentsStats();
            stats.add(this.segmentsStats);
            if (!includeSegmentFileSizes) {
                stats.clearFiles();
            }
            return stats;
        }
        return super.segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
    }

    @Override
    public DocsStats docStats() {
        return this.docsStats;
    }

    @Override
    public void trimUnreferencedTranslogFiles() {
        block20: {
            Store store = this.engineConfig.getStore();
            store.incRef();
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                List commits = DirectoryReader.listCommits((Directory)store.directory());
                if (commits.size() != 1 || this.translogStats.getTranslogSizeInBytes() <= this.translogStats.getUncommittedSizeInBytes()) break block20;
                Map commitUserData = this.getLastCommittedSegmentInfos().getUserData();
                String translogUuid = (String)commitUserData.get("translog_uuid");
                if (translogUuid == null) {
                    throw new IllegalStateException("commit doesn't contain translog unique id");
                }
                TranslogConfig translogConfig = this.engineConfig.getTranslogConfig();
                long localCheckpoint = Long.parseLong((String)commitUserData.get("local_checkpoint"));
                TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy(-1L, -1L, 0);
                translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpoint);
                try (Translog translog = new Translog(translogConfig, translogUuid, translogDeletionPolicy, this.engineConfig.getGlobalCheckpointSupplier(), this.engineConfig.getPrimaryTermSupplier(), seqNo -> {});){
                    translog.trimUnreferencedReaders();
                    this.translogStats = translog.stats();
                    assert (translog.currentFileGeneration() == translog.getMinFileGeneration()) : "translog was not trimmed  current gen " + translog.currentFileGeneration() + " != min gen " + translog.getMinFileGeneration();
                }
            }
            catch (Exception e) {
                try {
                    this.failEngine("translog trimming failed", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new EngineException(this.shardId, "failed to trim translog", e, new Object[0]);
            }
            finally {
                store.decRef();
            }
        }
    }
}

