/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String NAME = "same_shard";
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING = Setting.boolSetting("cluster.routing.allocation.same_shard.host", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean sameHost;
    private static final Decision YES_NONE_HOLD_COPY = Decision.single(Decision.Type.YES, "same_shard", "none of the nodes on this host hold a copy of this shard", new Object[0]);
    private static final Decision YES_AUTO_EXPAND_ALL = Decision.single(Decision.Type.YES, "same_shard", "same-host allocation is ignored, this index is set to auto-expand to all nodes", new Object[0]);
    private static final Decision YES_NO_COPY = Decision.single(Decision.Type.YES, "same_shard", "this node does not hold a copy of this shard", new Object[0]);

    public SameShardAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.sameHost = CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING, this::setSameHost);
    }

    private void setSameHost(boolean sameHost) {
        this.sameHost = sameHost;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        Decision decision = this.decideSameNode(shardRouting, node, allocation, assignedShards);
        if (decision.type() == Decision.Type.NO || !this.sameHost) {
            return decision;
        }
        if (IndexMetadata.INDEX_AUTO_EXPAND_REPLICAS_SETTING.get(allocation.metadata().getIndexSafe(shardRouting.index()).getSettings()).expandToAllNodes()) {
            return YES_AUTO_EXPAND_ALL;
        }
        if (node.node() != null) {
            for (RoutingNode checkNode : allocation.routingNodes()) {
                if (checkNode.node() == null) continue;
                boolean checkNodeOnSameHostName = false;
                boolean checkNodeOnSameHostAddress = false;
                if (Strings.hasLength(checkNode.node().getHostAddress()) && Strings.hasLength(node.node().getHostAddress())) {
                    if (checkNode.node().getHostAddress().equals(node.node().getHostAddress())) {
                        checkNodeOnSameHostAddress = true;
                    }
                } else if (Strings.hasLength(checkNode.node().getHostName()) && Strings.hasLength(node.node().getHostName()) && checkNode.node().getHostName().equals(node.node().getHostName())) {
                    checkNodeOnSameHostName = true;
                }
                if (!checkNodeOnSameHostAddress && !checkNodeOnSameHostName) continue;
                for (ShardRouting assignedShard : assignedShards) {
                    if (!checkNode.nodeId().equals(assignedShard.currentNodeId())) continue;
                    return allocation.debugDecision() ? SameShardAllocationDecider.debugNoAlreadyAllocatedToHost(node, allocation, checkNodeOnSameHostAddress) : Decision.NO;
                }
            }
        }
        return YES_NONE_HOLD_COPY;
    }

    private static Decision debugNoAlreadyAllocatedToHost(RoutingNode node, RoutingAllocation allocation, boolean checkNodeOnSameHostAddress) {
        String hostType = checkNodeOnSameHostAddress ? "address" : "name";
        String host = checkNodeOnSameHostAddress ? node.node().getHostAddress() : node.node().getHostName();
        return allocation.decision(Decision.NO, NAME, "a copy of this shard is already allocated to host %s [%s], on node [%s], and [%s] is [true] which forbids more than one node on this host from holding a copy of this shard", hostType, host, node.nodeId(), CLUSTER_ROUTING_ALLOCATION_SAME_HOST_SETTING.getKey());
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call force allocate on a non-primary shard";
        List<ShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting.shardId());
        return this.decideSameNode(shardRouting, node, allocation, assignedShards);
    }

    private Decision decideSameNode(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, Iterable<ShardRouting> assignedShards) {
        boolean debug = allocation.debugDecision();
        for (ShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            return debug ? SameShardAllocationDecider.debugNo(shardRouting, assignedShard) : Decision.NO;
        }
        return YES_NO_COPY;
    }

    private static Decision debugNo(ShardRouting shardRouting, ShardRouting assignedShard) {
        String explanation = assignedShard.isSameAllocation(shardRouting) ? "this shard is already allocated to this node [" + shardRouting.toString() + "]" : "a copy of this shard is already allocated to this node [" + assignedShard.toString() + "]";
        return Decision.single(Decision.Type.NO, NAME, explanation, new Object[0]);
    }
}

