/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.XMultiNormsLeafSimScorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public final class XCombinedFieldQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(XCombinedFieldQuery.class);
    private final TreeMap<String, FieldAndWeight> fieldAndWeights;
    private final BytesRef[] terms;
    private final Term[] fieldTerms;
    private final long ramBytesUsed;

    private XCombinedFieldQuery(TreeMap<String, FieldAndWeight> fieldAndWeights, BytesRef[] terms) {
        this.fieldAndWeights = fieldAndWeights;
        this.terms = terms;
        int numFieldTerms = fieldAndWeights.size() * terms.length;
        if (numFieldTerms > BooleanQuery.getMaxClauseCount()) {
            throw new BooleanQuery.TooManyClauses();
        }
        this.fieldTerms = new Term[numFieldTerms];
        Arrays.sort(terms);
        int pos = 0;
        for (String field : fieldAndWeights.keySet()) {
            for (BytesRef term : terms) {
                this.fieldTerms[pos++] = new Term(field, term);
            }
        }
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(fieldAndWeights) + RamUsageEstimator.sizeOfObject((Object)this.fieldTerms) + RamUsageEstimator.sizeOfObject((Object)terms);
    }

    public List<Term> getTerms() {
        return Collections.unmodifiableList(Arrays.asList(this.fieldTerms));
    }

    public String toString(String field) {
        StringBuilder builder = new StringBuilder("CombinedFieldQuery((");
        int pos = 0;
        for (FieldAndWeight fieldWeight : this.fieldAndWeights.values()) {
            if (pos++ != 0) {
                builder.append(" ");
            }
            builder.append(fieldWeight.field);
            if (fieldWeight.weight == 1.0f) continue;
            builder.append("^");
            builder.append(fieldWeight.weight);
        }
        builder.append(")(");
        pos = 0;
        for (BytesRef term : this.terms) {
            if (pos++ != 0) {
                builder.append(" ");
            }
            builder.append(term.utf8ToString());
        }
        builder.append("))");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        XCombinedFieldQuery that = (XCombinedFieldQuery)((Object)o);
        return Objects.equals(this.fieldAndWeights, that.fieldAndWeights) && Arrays.equals(this.terms, that.terms);
    }

    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + Objects.hash(this.fieldAndWeights);
        result = 31 * result + Arrays.hashCode(this.terms);
        return result;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.terms.length == 0) {
            return new BooleanQuery.Builder().build();
        }
        return this;
    }

    public void visit(QueryVisitor visitor) {
        Term[] selectedTerms = (Term[])Arrays.stream(this.fieldTerms).filter(t -> visitor.acceptField(t.field())).toArray(Term[]::new);
        if (selectedTerms.length > 0) {
            QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)this);
            v.consumeTerms((Query)this, selectedTerms);
        }
    }

    private BooleanQuery rewriteToBoolean() {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (Term term : this.fieldTerms) {
            bq.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        this.validateConsistentNorms(searcher.getIndexReader());
        if (scoreMode.needsScores()) {
            return new CombinedFieldWeight(this, searcher, scoreMode, boost);
        }
        BooleanQuery bq = this.rewriteToBoolean();
        return searcher.rewrite((Query)bq).createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
    }

    private void validateConsistentNorms(IndexReader reader) {
        boolean allFieldsHaveNorms = true;
        boolean noFieldsHaveNorms = true;
        for (LeafReaderContext context : reader.leaves()) {
            FieldInfos fieldInfos = context.reader().getFieldInfos();
            for (String field : this.fieldAndWeights.keySet()) {
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) continue;
                allFieldsHaveNorms &= fieldInfo.hasNorms();
                noFieldsHaveNorms &= fieldInfo.omitsNorms();
            }
        }
        if (!allFieldsHaveNorms && !noFieldsHaveNorms) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " requires norms to be consistent across fields: some fields cannot  have norms enabled, while others have norms disabled");
        }
    }

    static class FieldAndWeight {
        final String field;
        final float weight;

        FieldAndWeight(String field, float weight) {
            this.field = field;
            this.weight = weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldAndWeight that = (FieldAndWeight)o;
            return Float.compare(that.weight, this.weight) == 0 && Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field, Float.valueOf(this.weight));
        }
    }

    class CombinedFieldWeight
    extends Weight {
        private final IndexSearcher searcher;
        private final TermStates[] termStates;
        private final Similarity.SimScorer simWeight;

        CombinedFieldWeight(Query query, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            super(query);
            assert (scoreMode.needsScores());
            this.searcher = searcher;
            long docFreq = 0L;
            long totalTermFreq = 0L;
            this.termStates = new TermStates[XCombinedFieldQuery.this.fieldTerms.length];
            for (int i = 0; i < this.termStates.length; ++i) {
                TermStates ts;
                FieldAndWeight field = (FieldAndWeight)XCombinedFieldQuery.this.fieldAndWeights.get(XCombinedFieldQuery.this.fieldTerms[i].field());
                this.termStates[i] = ts = TermStates.build((IndexReaderContext)searcher.getTopReaderContext(), (Term)XCombinedFieldQuery.this.fieldTerms[i], (boolean)true);
                if (ts.docFreq() <= 0) continue;
                TermStatistics termStats = searcher.termStatistics(XCombinedFieldQuery.this.fieldTerms[i], ts.docFreq(), ts.totalTermFreq());
                docFreq = Math.max(termStats.docFreq(), docFreq);
                totalTermFreq = (long)((double)totalTermFreq + (double)field.weight * (double)termStats.totalTermFreq());
            }
            if (docFreq > 0L) {
                CollectionStatistics pseudoCollectionStats = this.mergeCollectionStatistics(searcher);
                TermStatistics pseudoTermStatistics = new TermStatistics(new BytesRef((CharSequence)"pseudo_term"), docFreq, Math.max(1L, totalTermFreq));
                this.simWeight = searcher.getSimilarity().scorer(boost, pseudoCollectionStats, new TermStatistics[]{pseudoTermStatistics});
            } else {
                this.simWeight = null;
            }
        }

        private CollectionStatistics mergeCollectionStatistics(IndexSearcher searcher) throws IOException {
            long maxDoc = searcher.getIndexReader().maxDoc();
            long docCount = 0L;
            long sumTotalTermFreq = 0L;
            long sumDocFreq = 0L;
            for (FieldAndWeight fieldWeight : XCombinedFieldQuery.this.fieldAndWeights.values()) {
                CollectionStatistics collectionStats = searcher.collectionStatistics(fieldWeight.field);
                if (collectionStats == null) continue;
                docCount = Math.max(collectionStats.docCount(), docCount);
                sumDocFreq = Math.max(collectionStats.sumDocFreq(), sumDocFreq);
                sumTotalTermFreq = (long)((double)sumTotalTermFreq + (double)fieldWeight.weight * (double)collectionStats.sumTotalTermFreq());
            }
            return new CollectionStatistics("pseudo_field", maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
        }

        public void extractTerms(Set<Term> termSet) {
            termSet.addAll(Arrays.asList(XCombinedFieldQuery.this.fieldTerms));
        }

        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            Weight weight = this.searcher.rewrite((Query)XCombinedFieldQuery.this.rewriteToBoolean()).createWeight(this.searcher, ScoreMode.COMPLETE, 1.0f);
            return weight.matches(context, doc);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq;
                if (scorer instanceof CombinedFieldScorer) {
                    freq = ((CombinedFieldScorer)scorer).freq();
                } else {
                    assert (scorer instanceof TermScorer);
                    freq = ((TermScorer)scorer).freq();
                }
                XMultiNormsLeafSimScorer docScorer = new XMultiNormsLeafSimScorer(this.simWeight, context.reader(), XCombinedFieldQuery.this.fieldAndWeights.values(), true);
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), (String)("termFreq=" + freq), (Explanation[])new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match((Number)scoreExplanation.getValue(), (String)("weight(" + this.getQuery() + " in " + doc + "), result of:"), (Explanation[])new Explanation[]{scoreExplanation});
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            ArrayList<PostingsEnum> iterators = new ArrayList<PostingsEnum>();
            ArrayList<FieldAndWeight> fields = new ArrayList<FieldAndWeight>();
            for (int i = 0; i < XCombinedFieldQuery.this.fieldTerms.length; ++i) {
                TermState state = this.termStates[i].get(context);
                if (state == null) continue;
                TermsEnum termsEnum = context.reader().terms(XCombinedFieldQuery.this.fieldTerms[i].field()).iterator();
                termsEnum.seekExact(XCombinedFieldQuery.this.fieldTerms[i].bytes(), state);
                PostingsEnum postingsEnum = termsEnum.postings(null, 8);
                iterators.add(postingsEnum);
                fields.add((FieldAndWeight)XCombinedFieldQuery.this.fieldAndWeights.get(XCombinedFieldQuery.this.fieldTerms[i].field()));
            }
            if (iterators.isEmpty()) {
                return null;
            }
            if (iterators.size() == 1) {
                LeafSimScorer scoringSimScorer = new LeafSimScorer(this.simWeight, context.reader(), ((FieldAndWeight)fields.get((int)0)).field, true);
                return new TermScorer((Weight)this, (PostingsEnum)iterators.get(0), scoringSimScorer);
            }
            XMultiNormsLeafSimScorer scoringSimScorer = new XMultiNormsLeafSimScorer(this.simWeight, context.reader(), fields, true);
            LeafSimScorer nonScoringSimScorer = new LeafSimScorer(this.simWeight, context.reader(), "pseudo_field", false);
            DisiPriorityQueue queue = new DisiPriorityQueue(iterators.size());
            for (int i = 0; i < iterators.size(); ++i) {
                float weight = ((FieldAndWeight)fields.get((int)i)).weight;
                queue.add((DisiWrapper)new WeightedDisiWrapper((Scorer)new TermScorer((Weight)this, (PostingsEnum)iterators.get(i), nonScoringSimScorer), weight));
            }
            DisjunctionDISIApproximation iterator = new DisjunctionDISIApproximation(queue);
            return new CombinedFieldScorer(this, queue, (DocIdSetIterator)iterator, scoringSimScorer);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class CombinedFieldScorer
    extends Scorer {
        private final DisiPriorityQueue queue;
        private final DocIdSetIterator iterator;
        private final XMultiNormsLeafSimScorer simScorer;

        CombinedFieldScorer(Weight weight, DisiPriorityQueue queue, DocIdSetIterator iterator, XMultiNormsLeafSimScorer simScorer) {
            super(weight);
            this.queue = queue;
            this.iterator = iterator;
            this.simScorer = simScorer;
        }

        public int docID() {
            return this.iterator.docID();
        }

        float freq() throws IOException {
            DisiWrapper w = this.queue.topList();
            float freq = ((WeightedDisiWrapper)w).freq();
            w = w.next;
            while (w != null) {
                if ((freq += ((WeightedDisiWrapper)w).freq()) < 0.0f) {
                    return 2.1474836E9f;
                }
                w = w.next;
            }
            return freq;
        }

        public float score() throws IOException {
            return this.simScorer.score(this.iterator.docID(), this.freq());
        }

        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }
    }

    private static class WeightedDisiWrapper
    extends DisiWrapper {
        final float weight;

        WeightedDisiWrapper(Scorer scorer, float weight) {
            super(scorer);
            this.weight = weight;
        }

        float freq() throws IOException {
            return this.weight * (float)((PostingsEnum)this.iterator).freq();
        }
    }

    public static class Builder {
        private final Map<String, FieldAndWeight> fieldAndWeights = new HashMap<String, FieldAndWeight>();
        private final Set<BytesRef> termsSet = new HashSet<BytesRef>();

        public Builder addField(String field) {
            return this.addField(field, 1.0f);
        }

        public Builder addField(String field, float weight) {
            if (weight < 1.0f) {
                throw new IllegalArgumentException("weight must be greater or equal to 1");
            }
            this.fieldAndWeights.put(field, new FieldAndWeight(field, weight));
            return this;
        }

        public Builder addTerm(BytesRef term) {
            if (this.termsSet.size() > BooleanQuery.getMaxClauseCount()) {
                throw new BooleanQuery.TooManyClauses();
            }
            this.termsSet.add(term);
            return this;
        }

        public XCombinedFieldQuery build() {
            int size = this.fieldAndWeights.size() * this.termsSet.size();
            if (size > BooleanQuery.getMaxClauseCount()) {
                throw new BooleanQuery.TooManyClauses();
            }
            BytesRef[] terms = this.termsSet.toArray(new BytesRef[0]);
            return new XCombinedFieldQuery(new TreeMap<String, FieldAndWeight>(this.fieldAndWeights), terms);
        }
    }
}

