/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class RestStopDatafeedAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/datafeeds/{" + DatafeedConfig.ID + "}/_stop")).replaces(RestRequest.Method.POST, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID + "}/_stop", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_stop_datafeed_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        StopDatafeedAction.Request request;
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = StopDatafeedAction.Request.parseRequest((String)datafeedId, (XContentParser)parser);
        } else {
            request = new StopDatafeedAction.Request(datafeedId);
            if (restRequest.hasParam(StopDatafeedAction.Request.TIMEOUT.getPreferredName())) {
                TimeValue stopTimeout = restRequest.paramAsTime(StopDatafeedAction.Request.TIMEOUT.getPreferredName(), StopDatafeedAction.DEFAULT_TIMEOUT);
                request.setStopTimeout(stopTimeout);
            }
            if (restRequest.hasParam(StopDatafeedAction.Request.FORCE.getPreferredName())) {
                request.setForce(restRequest.paramAsBoolean(StopDatafeedAction.Request.FORCE.getPreferredName(), request.isForce()));
            }
            if (restRequest.hasParam("allow_no_datafeeds")) {
                LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, () -> null, "allow_no_datafeeds", StopDatafeedAction.Request.ALLOW_NO_MATCH.getPreferredName());
            }
            request.setAllowNoMatch(restRequest.paramAsBoolean(StopDatafeedAction.Request.ALLOW_NO_MATCH.getPreferredName(), restRequest.paramAsBoolean("allow_no_datafeeds", request.allowNoMatch())));
        }
        return channel -> client.execute((ActionType)StopDatafeedAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestBuilderListener<StopDatafeedAction.Response>(channel){

            public RestResponse buildResponse(StopDatafeedAction.Response response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("stopped", response.isStopped());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

