/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process.logging;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CppLogMessage
implements ToXContentObject,
Writeable {
    public static final ParseField LOGGER_FIELD = new ParseField("logger", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp", new String[0]);
    public static final ParseField LEVEL_FIELD = new ParseField("level", new String[0]);
    public static final ParseField PID_FIELD = new ParseField("pid", new String[0]);
    public static final ParseField THREAD_FIELD = new ParseField("thread", new String[0]);
    public static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
    public static final ParseField CLASS_FIELD = new ParseField("class", new String[0]);
    public static final ParseField METHOD_FIELD = new ParseField("method", new String[0]);
    public static final ParseField FILE_FIELD = new ParseField("file", new String[0]);
    public static final ParseField LINE_FIELD = new ParseField("line", new String[0]);
    public static final ObjectParser<CppLogMessage, Void> PARSER = new ObjectParser(LOGGER_FIELD.getPreferredName(), () -> new CppLogMessage(Instant.now()));
    public static final ParseField TYPE;
    private String logger = "";
    private Instant timestamp;
    private String level = "";
    private long pid = 0L;
    private String thread = "";
    private String message = "";
    private String clazz = "";
    private String method = "";
    private String file = "";
    private long line = 0L;

    public CppLogMessage(Instant timestamp) {
        this.timestamp = Instant.ofEpochMilli(timestamp.toEpochMilli());
    }

    public CppLogMessage(StreamInput in) throws IOException {
        this.logger = in.readString();
        this.timestamp = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readInstant() : Instant.ofEpochMilli(in.readVLong());
        this.level = in.readString();
        this.pid = in.readVLong();
        this.thread = in.readString();
        this.message = in.readString();
        this.clazz = in.readString();
        this.method = in.readString();
        this.file = in.readString();
        this.line = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.logger);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeInstant(this.timestamp);
        } else {
            out.writeVLong(this.timestamp.toEpochMilli());
        }
        out.writeString(this.level);
        out.writeVLong(this.pid);
        out.writeString(this.thread);
        out.writeString(this.message);
        out.writeString(this.clazz);
        out.writeString(this.method);
        out.writeString(this.file);
        out.writeVLong(this.line);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LOGGER_FIELD.getPreferredName(), this.logger);
        builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestamp.toEpochMilli());
        builder.field(LEVEL_FIELD.getPreferredName(), this.level);
        builder.field(PID_FIELD.getPreferredName(), this.pid);
        builder.field(THREAD_FIELD.getPreferredName(), this.thread);
        builder.field(MESSAGE_FIELD.getPreferredName(), this.message);
        builder.field(CLASS_FIELD.getPreferredName(), this.clazz);
        builder.field(METHOD_FIELD.getPreferredName(), this.method);
        builder.field(FILE_FIELD.getPreferredName(), this.file);
        builder.field(LINE_FIELD.getPreferredName(), this.line);
        builder.endObject();
        return builder;
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Instant d) {
        this.timestamp = Instant.ofEpochMilli(d.toEpochMilli());
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public long getLine() {
        return this.line;
    }

    public void setLine(long line) {
        this.line = line;
    }

    public boolean isSimilarTo(CppLogMessage other) {
        return other != null && this.line > 0L && this.line == other.line && this.file.equals(other.file) && this.level.equals(other.level);
    }

    public int hashCode() {
        return Objects.hash(this.logger, this.timestamp, this.level, this.pid, this.thread, this.message, this.clazz, this.method, this.file, this.line);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CppLogMessage)) {
            return false;
        }
        CppLogMessage that = (CppLogMessage)other;
        return Objects.equals(this.logger, that.logger) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.level, that.level) && this.pid == that.pid && Objects.equals(this.thread, that.thread) && Objects.equals(this.message, that.message) && Objects.equals(this.clazz, that.clazz) && Objects.equals(this.method, that.method) && Objects.equals(this.file, that.file) && this.line == that.line;
    }

    static {
        PARSER.declareString(CppLogMessage::setLogger, LOGGER_FIELD);
        PARSER.declareField(CppLogMessage::setTimestamp, p -> Instant.ofEpochMilli(p.longValue()), TIMESTAMP_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareString(CppLogMessage::setLevel, LEVEL_FIELD);
        PARSER.declareLong(CppLogMessage::setPid, PID_FIELD);
        PARSER.declareString(CppLogMessage::setThread, THREAD_FIELD);
        PARSER.declareString(CppLogMessage::setMessage, MESSAGE_FIELD);
        PARSER.declareString(CppLogMessage::setClazz, CLASS_FIELD);
        PARSER.declareString(CppLogMessage::setMethod, METHOD_FIELD);
        PARSER.declareString(CppLogMessage::setFile, FILE_FIELD);
        PARSER.declareLong(CppLogMessage::setLine, LINE_FIELD);
        TYPE = new ParseField("cpp_log_message", new String[0]);
    }
}

