/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ControllerResponse
implements ToXContentObject {
    public static final ParseField TYPE = new ParseField("controller_response", new String[0]);
    public static final ParseField COMMAND_ID = new ParseField("id", new String[0]);
    public static final ParseField SUCCESS = new ParseField("success", new String[0]);
    public static final ParseField REASON = new ParseField("reason", new String[0]);
    public static final ConstructingObjectParser<ControllerResponse, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new ControllerResponse((Integer)a[0], (Boolean)a[1], (String)a[2]));
    private final int commandId;
    private final boolean success;
    private final String reason;

    ControllerResponse(int commandId, boolean success, String reason) {
        this.commandId = commandId;
        this.success = success;
        this.reason = reason;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getReason() {
        return this.reason;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(COMMAND_ID.getPreferredName(), this.commandId);
        builder.field(SUCCESS.getPreferredName(), this.success);
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControllerResponse that = (ControllerResponse)o;
        return this.commandId == that.commandId && this.success == that.success && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.commandId, this.success, this.reason);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), COMMAND_ID);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), SUCCESS);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
    }
}

