/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public abstract class AbstractMlTokenizer
extends Tokenizer {
    protected final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    protected final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    protected final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    protected int nextOffset;
    protected int skippedPositions;

    protected AbstractMlTokenizer() {
    }

    public final void end() throws IOException {
        super.end();
        int finalOffset = this.nextOffset + (int)this.input.skip(Integer.MAX_VALUE);
        int correctedFinalOffset = this.correctOffset(finalOffset);
        this.offsetAtt.setOffset(correctedFinalOffset, correctedFinalOffset);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    public void reset() throws IOException {
        super.reset();
        this.nextOffset = 0;
        this.skippedPositions = 0;
    }
}

