/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.classification.ClassificationStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.MemoryUsage;
import org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection.OutlierDetectionStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.regression.RegressionStats;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.ChunkedTrainedModelPersister;
import org.elasticsearch.xpack.ml.dataframe.process.DataFrameRowsJoiner;
import org.elasticsearch.xpack.ml.dataframe.process.results.AnalyticsResult;
import org.elasticsearch.xpack.ml.dataframe.process.results.ModelMetadata;
import org.elasticsearch.xpack.ml.dataframe.process.results.RowResults;
import org.elasticsearch.xpack.ml.dataframe.process.results.TrainedModelDefinitionChunk;
import org.elasticsearch.xpack.ml.dataframe.stats.StatsHolder;
import org.elasticsearch.xpack.ml.dataframe.stats.StatsPersister;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.inference.modelsize.ModelSizeInfo;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class AnalyticsResultProcessor {
    private static final Logger LOGGER = LogManager.getLogger(AnalyticsResultProcessor.class);
    private static final int MAX_PROGRESS_BEFORE_COMPLETION = 98;
    private final DataFrameAnalyticsConfig analytics;
    private final DataFrameRowsJoiner dataFrameRowsJoiner;
    private final StatsHolder statsHolder;
    private final DataFrameAnalyticsAuditor auditor;
    private final StatsPersister statsPersister;
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final ChunkedTrainedModelPersister chunkedTrainedModelPersister;
    private volatile String failure;
    private volatile boolean isCancelled;
    private long processedRows;
    private volatile String latestModelId;

    public AnalyticsResultProcessor(DataFrameAnalyticsConfig analytics, DataFrameRowsJoiner dataFrameRowsJoiner, StatsHolder statsHolder, TrainedModelProvider trainedModelProvider, DataFrameAnalyticsAuditor auditor, StatsPersister statsPersister, ExtractedFields extractedFields) {
        this.analytics = Objects.requireNonNull(analytics);
        this.dataFrameRowsJoiner = Objects.requireNonNull(dataFrameRowsJoiner);
        this.statsHolder = Objects.requireNonNull(statsHolder);
        this.auditor = Objects.requireNonNull(auditor);
        this.statsPersister = Objects.requireNonNull(statsPersister);
        this.chunkedTrainedModelPersister = new ChunkedTrainedModelPersister(trainedModelProvider, analytics, auditor, this::setAndReportFailure, extractedFields);
    }

    @Nullable
    public String getFailure() {
        return this.failure == null ? this.dataFrameRowsJoiner.getFailure() : this.failure;
    }

    public void awaitForCompletion() {
        try {
            this.completionLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.setAndReportFailure((Exception)ExceptionsHelper.serverError((String)"interrupted waiting for results processor to complete", (Throwable)e));
        }
    }

    public void cancel() {
        this.dataFrameRowsJoiner.cancel();
        this.isCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AnalyticsProcess<AnalyticsResult> process) {
        long totalRows = process.getConfig().rows();
        try (DataFrameRowsJoiner resultsJoiner = this.dataFrameRowsJoiner;){
            Iterator<AnalyticsResult> iterator = process.readAnalyticsResults();
            while (iterator.hasNext()) {
                this.processResult(iterator.next(), resultsJoiner, totalRows);
            }
        }
        catch (Exception e) {
            if (this.isCancelled) {
            } else {
                this.setAndReportFailure(e);
            }
        }
        finally {
            if (!this.isCancelled && this.failure == null) {
                this.completeResultsProgress();
            }
            this.completionLatch.countDown();
        }
    }

    private void updateResultsProgress(int progress) {
        this.statsHolder.getProgressTracker().updateWritingResultsProgress(Math.min(progress, 98));
    }

    private void completeResultsProgress() {
        this.statsHolder.getProgressTracker().updateWritingResultsProgress(100);
    }

    private void processResult(AnalyticsResult result, DataFrameRowsJoiner resultsJoiner, long totalRows) {
        RegressionStats regressionStats;
        ClassificationStats classificationStats;
        OutlierDetectionStats outlierDetectionStats;
        MemoryUsage memoryUsage;
        ModelMetadata modelMetadata;
        TrainedModelDefinitionChunk trainedModelDefinitionChunk;
        ModelSizeInfo modelSize;
        PhaseProgress phaseProgress;
        RowResults rowResults = result.getRowResults();
        if (rowResults != null && !this.isCancelled) {
            this.processRowResult(resultsJoiner, totalRows, rowResults);
        }
        if ((phaseProgress = result.getPhaseProgress()) != null) {
            LOGGER.debug("[{}] progress for phase [{}] updated to [{}]", (Object)this.analytics.getId(), (Object)phaseProgress.getPhase(), (Object)phaseProgress.getProgressPercent());
            this.statsHolder.getProgressTracker().updatePhase(phaseProgress);
        }
        if ((modelSize = result.getModelSizeInfo()) != null) {
            this.latestModelId = this.chunkedTrainedModelPersister.createAndIndexInferenceModelConfig(modelSize);
        }
        if ((trainedModelDefinitionChunk = result.getTrainedModelDefinitionChunk()) != null && !this.isCancelled) {
            this.chunkedTrainedModelPersister.createAndIndexInferenceModelDoc(trainedModelDefinitionChunk);
        }
        if ((modelMetadata = result.getModelMetadata()) != null) {
            this.chunkedTrainedModelPersister.createAndIndexInferenceModelMetadata(modelMetadata);
        }
        if ((memoryUsage = result.getMemoryUsage()) != null) {
            this.processMemoryUsage(memoryUsage);
        }
        if ((outlierDetectionStats = result.getOutlierDetectionStats()) != null) {
            this.statsHolder.setAnalysisStats((AnalysisStats)outlierDetectionStats);
            this.statsPersister.persistWithRetry((ToXContentObject)outlierDetectionStats, arg_0 -> ((OutlierDetectionStats)outlierDetectionStats).documentId(arg_0));
        }
        if ((classificationStats = result.getClassificationStats()) != null) {
            this.statsHolder.setAnalysisStats((AnalysisStats)classificationStats);
            this.statsPersister.persistWithRetry((ToXContentObject)classificationStats, arg_0 -> ((ClassificationStats)classificationStats).documentId(arg_0));
        }
        if ((regressionStats = result.getRegressionStats()) != null) {
            this.statsHolder.setAnalysisStats((AnalysisStats)regressionStats);
            this.statsPersister.persistWithRetry((ToXContentObject)regressionStats, arg_0 -> ((RegressionStats)regressionStats).documentId(arg_0));
        }
    }

    private void processRowResult(DataFrameRowsJoiner rowsJoiner, long totalRows, RowResults rowResults) {
        rowsJoiner.processRowResults(rowResults);
        if (this.processedRows == 0L) {
            LOGGER.info("[{}] Started writing results", (Object)this.analytics.getId());
            this.auditor.info(this.analytics.getId(), Messages.getMessage((String)"Started writing results"));
        }
        ++this.processedRows;
        this.updateResultsProgress(this.processedRows >= totalRows ? 100 : (int)((double)this.processedRows * 100.0 / (double)totalRows));
    }

    private void setAndReportFailure(Exception e) {
        LOGGER.error((Message)new ParameterizedMessage("[{}] Error processing results; ", (Object)this.analytics.getId()), (Throwable)e);
        this.failure = "error processing results; " + e.getMessage();
        this.auditor.error(this.analytics.getId(), "Error processing results; " + e.getMessage());
    }

    private void processMemoryUsage(MemoryUsage memoryUsage) {
        this.statsHolder.setMemoryUsage(memoryUsage);
        this.statsPersister.persistWithRetry((ToXContentObject)memoryUsage, arg_0 -> ((MemoryUsage)memoryUsage).documentId(arg_0));
    }

    @Nullable
    public String getLatestModelId() {
        return this.latestModelId;
    }
}

