/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.task.OpenJobPersistentTasksExecutor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportOpenJobAction
extends TransportMasterNodeAction<OpenJobAction.Request, NodeAcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportOpenJobAction.class);
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final JobConfigProvider jobConfigProvider;
    private final MlMemoryTracker memoryTracker;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;
    private final Client client;

    @Inject
    public TransportOpenJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobConfigProvider jobConfigProvider, MlMemoryTracker memoryTracker, Client client) {
        super("cluster:admin/xpack/ml/job/open", transportService, clusterService, threadPool, actionFilters, OpenJobAction.Request::new, indexNameExpressionResolver, NodeAcknowledgedResponse::new, "same");
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.jobConfigProvider = jobConfigProvider;
        this.memoryTracker = memoryTracker;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
        this.client = client;
    }

    protected ClusterBlockException checkBlock(OpenJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(OpenJobAction.Request request, ClusterState state, final ActionListener<NodeAcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.jobIsEligibleForMigration(request.getJobParams().getJobId(), state)) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.configHasNotBeenMigrated((String)"open job", (String)request.getJobParams().getJobId())));
            return;
        }
        final OpenJobAction.JobParams jobParams = request.getJobParams();
        if (this.licenseState.checkFeature(XPackLicenseState.Feature.MACHINE_LEARNING)) {
            final ActionListener clearJobFinishTime = ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.clearJobFinishedTime((NodeAcknowledgedResponse)response, state, jobParams.getJobId(), request.masterNodeTimeout(), listener);
                } else {
                    listener.onResponse(response);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener<PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams>> waitForJobToStart = new ActionListener<PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams>>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> task) {
                    TransportOpenJobAction.this.waitForJobStarted(task.getId(), jobParams, (ActionListener<NodeAcknowledgedResponse>)clearJobFinishTime);
                }

                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                        e = new ElasticsearchStatusException("Cannot open job [{}] because it has already been opened", RestStatus.CONFLICT, e, new Object[]{jobParams.getJobId()});
                    }
                    listener.onFailure((Exception)e);
                }
            };
            ActionListener memoryRequirementRefreshListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$1(jobParams, (ActionListener)waitForJobToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
            ActionListener getJobHandler = ActionListener.wrap(response -> this.memoryTracker.refreshAnomalyDetectorJobMemoryAndAllOthers(jobParams.getJobId(), (ActionListener<Long>)memoryRequirementRefreshListener), arg_0 -> listener.onFailure(arg_0));
            this.jobConfigProvider.getJob(jobParams.getJobId(), (ActionListener<Job.Builder>)ActionListener.wrap(builder -> {
                jobParams.setJob(builder.build());
                getJobHandler.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    private void waitForJobStarted(String taskId, final OpenJobAction.JobParams jobParams, final ActionListener<NodeAcknowledgedResponse> listener) {
        final JobPredicate predicate = new JobPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, jobParams.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<OpenJobAction.JobParams>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> persistentTask) {
                if (predicate.exception != null) {
                    if (predicate.shouldCancel) {
                        TransportOpenJobAction.this.cancelJobStart((PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams>)persistentTask, predicate.exception, (ActionListener<NodeAcknowledgedResponse>)listener);
                    } else {
                        listener.onFailure(predicate.exception);
                    }
                } else {
                    listener.onResponse((Object)new NodeAcknowledgedResponse(true, predicate.node));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Opening job [{}] timed out after [{}]", new Object[]{jobParams.getJob(), timeout})));
            }
        });
    }

    private void clearJobFinishedTime(NodeAcknowledgedResponse response, ClusterState clusterState, String jobId, TimeValue masterNodeTimeout, ActionListener<NodeAcknowledgedResponse> listener) {
        JobUpdate update = new JobUpdate.Builder(jobId).setClearFinishTime(true).build();
        ActionListener clearedTimeListener = ActionListener.wrap(job -> listener.onResponse((Object)response), e -> {
            logger.error((Message)new ParameterizedMessage("[{}] Failed to clear finished_time", (Object)jobId), (Throwable)e);
            listener.onResponse((Object)response);
        });
        ActionListener mappingsUpdatedListener = ActionListener.wrap(mappingUpdateResponse -> this.jobConfigProvider.updateJob(jobId, update, null, (ActionListener<Job>)clearedTimeListener), e -> {
            logger.error((Message)new ParameterizedMessage("[{}] Failed to update mapping; not clearing finished_time", (Object)jobId), (Throwable)e);
            listener.onResponse((Object)response);
        });
        ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)clusterState, (TimeValue)masterNodeTimeout, (ActionListener)mappingsUpdatedListener);
    }

    private void cancelJobStart(final PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> persistentTask, final Exception exception, final ActionListener<NodeAcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                logger.error(() -> new ParameterizedMessage("[{}] Failed to cancel persistent task that could not be assigned due to [{}]", (Object)((OpenJobAction.JobParams)persistentTask.getParams()).getJobId(), (Object)exception.getMessage()), (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    private /* synthetic */ void lambda$masterOperation$1(OpenJobAction.JobParams jobParams, ActionListener waitForJobToStart, Long mem) throws Exception {
        this.persistentTasksService.sendStartRequest(MlTasks.jobTaskId((String)jobParams.getJobId()), "xpack/ml/job", (PersistentTaskParams)jobParams, waitForJobToStart);
    }

    private static class JobPredicate
    implements Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> {
        private volatile Exception exception;
        private volatile String node = "";
        private volatile boolean shouldCancel;

        private JobPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
            JobState jobState = JobState.CLOSED;
            String reason = null;
            if (persistentTask != null) {
                JobTaskState jobTaskState = (JobTaskState)persistentTask.getState();
                jobState = jobTaskState == null ? JobState.OPENING : jobTaskState.getState();
                reason = jobTaskState == null ? null : jobTaskState.getReason();
                PersistentTasksCustomMetadata.Assignment assignment = persistentTask.getAssignment();
                if (assignment != null && assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                    return true;
                }
                OpenJobAction.JobParams params = (OpenJobAction.JobParams)persistentTask.getParams();
                Optional<ElasticsearchException> assignmentException = OpenJobPersistentTasksExecutor.checkAssignmentState(assignment, params.getJobId(), logger);
                if (assignmentException.isPresent()) {
                    this.exception = (Exception)((Object)assignmentException.get());
                    this.shouldCancel = true;
                    return true;
                }
            }
            switch (jobState) {
                case OPENING: 
                case CLOSED: {
                    return false;
                }
                case OPENED: {
                    this.node = persistentTask.getExecutorNode();
                    return true;
                }
                case CLOSING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)"The job has been {} while waiting to be {}", (Object[])new Object[]{JobState.CLOSED, JobState.OPENED});
                    return true;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)"Unexpected job state [{}] {}while waiting for job to be {}", (Object[])new Object[]{jobState, reason == null ? "" : "with reason [" + reason + "] ", JobState.OPENED});
            return true;
        }
    }
}

