/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractTransportGetResourcesAction;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TransportGetDataFrameAnalyticsAction
extends AbstractTransportGetResourcesAction<DataFrameAnalyticsConfig, GetDataFrameAnalyticsAction.Request, GetDataFrameAnalyticsAction.Response> {
    @Inject
    public TransportGetDataFrameAnalyticsAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/xpack/ml/data_frame/analytics/get", transportService, actionFilters, GetDataFrameAnalyticsAction.Request::new, client, xContentRegistry);
    }

    protected ParseField getResultsField() {
        return GetDataFrameAnalyticsAction.Response.RESULTS_FIELD;
    }

    protected String[] getIndices() {
        return new String[]{MlConfigIndex.indexName()};
    }

    protected DataFrameAnalyticsConfig parse(XContentParser parser) {
        return ((DataFrameAnalyticsConfig.Builder)DataFrameAnalyticsConfig.LENIENT_PARSER.apply(parser, null)).build();
    }

    protected ResourceNotFoundException notFoundException(String resourceId) {
        return ExceptionsHelper.missingDataFrameAnalytics((String)resourceId);
    }

    protected void doExecute(Task task, GetDataFrameAnalyticsAction.Request request, ActionListener<GetDataFrameAnalyticsAction.Response> listener) {
        this.searchResources((AbstractGetResourcesRequest)request, ActionListener.wrap(queryPage -> listener.onResponse((Object)new GetDataFrameAnalyticsAction.Response(queryPage)), arg_0 -> listener.onFailure(arg_0)));
    }

    @Nullable
    protected QueryBuilder additionalQuery() {
        return QueryBuilders.termQuery((String)DataFrameAnalyticsConfig.CONFIG_TYPE.getPreferredName(), (String)"data_frame_analytics_config");
    }

    protected String executionOrigin() {
        return "ml";
    }

    protected String extractIdFromResource(DataFrameAnalyticsConfig config) {
        return config.getId();
    }
}

