/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.ml.MlConfigMigrator;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class MlAssignmentNotifier
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlAssignmentNotifier.class);
    private final AnomalyDetectionAuditor anomalyDetectionAuditor;
    private final DataFrameAnalyticsAuditor dataFrameAnalyticsAuditor;
    private final MlConfigMigrator mlConfigMigrator;
    private final ThreadPool threadPool;

    MlAssignmentNotifier(AnomalyDetectionAuditor anomalyDetectionAuditor, DataFrameAnalyticsAuditor dataFrameAnalyticsAuditor, ThreadPool threadPool, MlConfigMigrator mlConfigMigrator, ClusterService clusterService) {
        this.anomalyDetectionAuditor = anomalyDetectionAuditor;
        this.dataFrameAnalyticsAuditor = dataFrameAnalyticsAuditor;
        this.mlConfigMigrator = mlConfigMigrator;
        this.threadPool = threadPool;
        clusterService.addListener((ClusterStateListener)this);
    }

    private String executorName() {
        return "generic";
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.localNodeMaster()) {
            return;
        }
        this.mlConfigMigrator.migrateConfigs(event.state(), (ActionListener<Boolean>)ActionListener.wrap(response -> this.threadPool.executor(this.executorName()).execute(() -> this.auditChangesToMlTasks(event)), e -> {
            logger.error("error migrating ml configurations", (Throwable)e);
            this.threadPool.executor(this.executorName()).execute(() -> this.auditChangesToMlTasks(event));
        }));
    }

    private void auditChangesToMlTasks(ClusterChangedEvent event) {
        PersistentTasksCustomMetadata currentTasks;
        if (!event.metadataChanged()) {
            return;
        }
        PersistentTasksCustomMetadata previousTasks = (PersistentTasksCustomMetadata)event.previousState().getMetadata().custom("persistent_tasks");
        if (Objects.equals(previousTasks, currentTasks = (PersistentTasksCustomMetadata)event.state().getMetadata().custom("persistent_tasks"))) {
            return;
        }
        this.auditMlTasks(event.state().nodes(), previousTasks, currentTasks, false);
    }

    public void auditUnassignedMlTasks(DiscoveryNodes nodes, PersistentTasksCustomMetadata tasks) {
        this.auditMlTasks(nodes, tasks, tasks, true);
    }

    private void auditMlTasks(DiscoveryNodes nodes, PersistentTasksCustomMetadata previousTasks, PersistentTasksCustomMetadata currentTasks, boolean alwaysAuditUnassigned) {
        for (PersistentTasksCustomMetadata.PersistentTask currentTask : currentTasks.tasks()) {
            DiscoveryNode node;
            boolean isTaskAssigned;
            PersistentTasksCustomMetadata.Assignment currentAssignment = currentTask.getAssignment();
            PersistentTasksCustomMetadata.PersistentTask previousTask = previousTasks != null ? previousTasks.getTask(currentTask.getId()) : null;
            PersistentTasksCustomMetadata.Assignment previousAssignment = previousTask != null ? previousTask.getAssignment() : null;
            boolean bl = isTaskAssigned = currentAssignment.getExecutorNode() != null;
            if (Objects.equals(currentAssignment, previousAssignment) && (isTaskAssigned || !alwaysAuditUnassigned)) continue;
            if ("xpack/ml/job".equals(currentTask.getTaskName())) {
                String jobId = ((OpenJobAction.JobParams)currentTask.getParams()).getJobId();
                if (isTaskAssigned) {
                    node = nodes.get(currentAssignment.getExecutorNode());
                    this.anomalyDetectionAuditor.info(jobId, "Opening job on node [" + node.toString() + "]");
                    continue;
                }
                this.anomalyDetectionAuditor.warning(jobId, "No node found to open job. Reasons [" + currentAssignment.getExplanation() + "]");
                continue;
            }
            if ("xpack/ml/datafeed".equals(currentTask.getTaskName())) {
                StartDatafeedAction.DatafeedParams datafeedParams = (StartDatafeedAction.DatafeedParams)currentTask.getParams();
                String jobId = datafeedParams.getJobId();
                if (isTaskAssigned) {
                    DiscoveryNode node2 = nodes.get(currentAssignment.getExecutorNode());
                    if (jobId == null) continue;
                    this.anomalyDetectionAuditor.info(jobId, "Starting datafeed [" + datafeedParams.getDatafeedId() + "] on node [" + node2 + "]");
                    continue;
                }
                String msg = "No node found to start datafeed [" + datafeedParams.getDatafeedId() + "]. Reasons [" + currentAssignment.getExplanation() + "]";
                if (!alwaysAuditUnassigned) {
                    logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                }
                if (jobId == null) continue;
                this.anomalyDetectionAuditor.warning(jobId, msg);
                continue;
            }
            if (!"xpack/ml/data_frame/analytics".equals(currentTask.getTaskName())) continue;
            String id = ((StartDataFrameAnalyticsAction.TaskParams)currentTask.getParams()).getId();
            if (isTaskAssigned) {
                node = nodes.get(currentAssignment.getExecutorNode());
                this.dataFrameAnalyticsAuditor.info(id, "Starting analytics on node [" + node.toString() + "]");
                continue;
            }
            this.dataFrameAnalyticsAuditor.warning(id, "No node found to start analytics. Reasons [" + currentAssignment.getExplanation() + "]");
        }
    }
}

