/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.jira;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.notification.jira.JiraIssue;

public class JiraAction
implements Action {
    public static final String TYPE = "jira";
    @Nullable
    final String account;
    @Nullable
    final HttpProxy proxy;
    final Map<String, Object> fields;

    public JiraAction(@Nullable String account, Map<String, Object> fields, HttpProxy proxy) {
        this.account = account;
        this.fields = fields;
        this.proxy = proxy;
    }

    public String type() {
        return TYPE;
    }

    public String getAccount() {
        return this.account;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraAction that = (JiraAction)o;
        return Objects.equals(this.account, that.account) && Objects.equals(this.fields, that.fields) && Objects.equals(this.proxy, that.proxy);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.fields, this.proxy);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.account != null) {
            builder.field(Field.ACCOUNT.getPreferredName(), this.account);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        builder.field(Field.FIELDS.getPreferredName(), this.fields);
        return builder.endObject();
    }

    public static JiraAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String account = null;
        HttpProxy proxy = null;
        Map fields = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.ACCOUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    account = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. expected [{}] to be of type string, but found [{}] instead", new Object[]{TYPE, watchId, actionId, Field.ACCOUNT.getPreferredName(), token});
            }
            if (Field.PROXY.match(currentFieldName, parser.getDeprecationHandler())) {
                proxy = HttpProxy.parse(parser);
                continue;
            }
            if (Field.FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    fields = parser.map();
                    continue;
                }
                catch (Exception e) {
                    throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. failed to parse [{}] field", (Throwable)e, new Object[]{TYPE, watchId, actionId, Field.FIELDS.getPreferredName()});
                }
            }
            throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. unexpected token [{}/{}]", new Object[]{TYPE, watchId, actionId, token, currentFieldName});
        }
        if (fields == null) {
            fields = Collections.emptyMap();
        }
        return new JiraAction(account, fields, proxy);
    }

    public static Builder builder(String account, Map<String, Object> fields) {
        return new Builder(new JiraAction(account, fields, null));
    }

    public static interface Field {
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField PROXY = new ParseField("proxy", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
    }

    public static class Builder
    implements Action.Builder<JiraAction> {
        final JiraAction action;

        public Builder(JiraAction action) {
            this.action = action;
        }

        public JiraAction build() {
            return this.action;
        }
    }

    static class Simulated
    extends Action.Result {
        private final Map<String, Object> fields;

        protected Simulated(Map<String, Object> fields) {
            super(JiraAction.TYPE, Action.Result.Status.SIMULATED);
            this.fields = fields;
        }

        public Map<String, Object> getFields() {
            return this.fields;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject(this.type).field(Field.FIELDS.getPreferredName(), this.fields).endObject();
        }
    }

    public static class Executed
    extends Action.Result {
        private final JiraIssue result;

        public Executed(JiraIssue result) {
            super(JiraAction.TYPE, result.successful() ? Action.Result.Status.SUCCESS : Action.Result.Status.FAILURE);
            this.result = result;
        }

        public JiraIssue getResult() {
            return this.result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(this.type, (ToXContent)this.result, params);
        }
    }
}

