/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanQuery;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.GeoTileGridValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.transform.transforms.pivot.DateHistogramGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.HistogramGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.transform.transforms.Function;

public class CompositeBucketsChangeCollector
implements Function.ChangeCollector {
    private static final Map<String, Object> AFTER_KEY_MAGIC_FOR_NON_COMPOSITE_COLLECTORS = Collections.singletonMap("_transform", "no_composite_after_key");
    private static final String COMPOSITE_AGGREGATION_NAME = "_transform_change_collector";
    private final Map<String, FieldCollector> fieldCollectors;
    private final CompositeAggregationBuilder compositeAggregation;

    private CompositeBucketsChangeCollector(@Nullable CompositeAggregationBuilder compositeAggregation, Map<String, FieldCollector> fieldCollectors) {
        this.compositeAggregation = compositeAggregation;
        this.fieldCollectors = fieldCollectors;
    }

    @Override
    public SearchSourceBuilder buildChangesQuery(SearchSourceBuilder sourceBuilder, Map<String, Object> position, int pageSize) {
        sourceBuilder.size(0);
        for (FieldCollector fieldCollector : this.fieldCollectors.values()) {
            if (position == null || position.isEmpty()) {
                for (AggregationBuilder fieldCollectorAgg : fieldCollector.aggregateChanges()) {
                    sourceBuilder.aggregation(fieldCollectorAgg);
                }
            }
            pageSize = Math.min(pageSize, fieldCollector.getMaxPageSize());
        }
        if (this.compositeAggregation != null) {
            CompositeAggregationBuilder changesAgg = this.compositeAggregation;
            changesAgg.size(pageSize).aggregateAfter(position);
            sourceBuilder.aggregation((AggregationBuilder)changesAgg);
        }
        return sourceBuilder;
    }

    @Override
    public QueryBuilder buildFilterQuery(long lastCheckpointTimestamp, long nextCheckpointTimestamp) {
        if (this.fieldCollectors.size() == 1) {
            return this.fieldCollectors.values().iterator().next().filterByChanges(lastCheckpointTimestamp, nextCheckpointTimestamp);
        }
        BoolQueryBuilder filteredQuery = new BoolQueryBuilder();
        for (FieldCollector fieldCollector : this.fieldCollectors.values()) {
            QueryBuilder filter = fieldCollector.filterByChanges(lastCheckpointTimestamp, nextCheckpointTimestamp);
            if (filter == null) continue;
            filteredQuery.filter(filter);
        }
        return filteredQuery;
    }

    @Override
    public Map<String, Object> processSearchResponse(SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return null;
        }
        boolean isDone = true;
        for (FieldCollector fieldCollector : this.fieldCollectors.values()) {
            isDone &= fieldCollector.collectChangesFromAggregations(aggregations);
        }
        CompositeAggregation compositeAggResults = (CompositeAggregation)aggregations.get(COMPOSITE_AGGREGATION_NAME);
        assert (!(this.compositeAggregation == null ^ compositeAggResults == null));
        if (compositeAggResults != null) {
            List buckets = compositeAggResults.getBuckets();
            for (FieldCollector fieldCollector : this.fieldCollectors.values()) {
                isDone &= fieldCollector.collectChangesFromCompositeBuckets(buckets);
            }
            if (!isDone) {
                return compositeAggResults.afterKey();
            }
        } else if (!isDone) {
            return AFTER_KEY_MAGIC_FOR_NON_COMPOSITE_COLLECTORS;
        }
        return null;
    }

    @Override
    public void clear() {
        this.fieldCollectors.forEach((k, c) -> c.clear());
    }

    @Override
    public boolean isOptimized() {
        return this.fieldCollectors.values().stream().anyMatch(FieldCollector::isOptimized);
    }

    @Override
    public boolean queryForChanges() {
        return this.fieldCollectors.values().stream().anyMatch(FieldCollector::queryForChanges);
    }

    public static Function.ChangeCollector buildChangeCollector(Map<String, SingleGroupSource> groups, String synchronizationField) {
        Map<String, FieldCollector> fieldCollectors = CompositeBucketsChangeCollector.createFieldCollectors(groups, synchronizationField);
        return new CompositeBucketsChangeCollector(CompositeBucketsChangeCollector.createCompositeAgg(fieldCollectors), fieldCollectors);
    }

    private static CompositeAggregationBuilder createCompositeAgg(Map<String, FieldCollector> fieldCollectors) {
        ArrayList sources = new ArrayList();
        for (FieldCollector fc : fieldCollectors.values()) {
            CompositeValuesSourceBuilder<?> sourceBuilder = fc.getCompositeValueSourceBuilder();
            if (sourceBuilder == null) continue;
            sources.add(sourceBuilder);
        }
        if (sources.isEmpty()) {
            return null;
        }
        return new CompositeAggregationBuilder(COMPOSITE_AGGREGATION_NAME, sources);
    }

    static Map<String, FieldCollector> createFieldCollectors(Map<String, SingleGroupSource> groups, String synchronizationField) {
        HashMap<String, FieldCollector> fieldCollectors = new HashMap<String, FieldCollector>();
        block6: for (Map.Entry<String, SingleGroupSource> entry : groups.entrySet()) {
            if (entry.getValue().getScriptConfig() != null) continue;
            switch (entry.getValue().getType()) {
                case TERMS: {
                    fieldCollectors.put(entry.getKey(), new TermsFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket()));
                    continue block6;
                }
                case HISTOGRAM: {
                    fieldCollectors.put(entry.getKey(), new HistogramFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket(), ((HistogramGroupSource)entry.getValue()).getInterval()));
                    continue block6;
                }
                case DATE_HISTOGRAM: {
                    fieldCollectors.put(entry.getKey(), !entry.getValue().getMissingBucket() && entry.getValue().getField() != null && entry.getValue().getField().equals(synchronizationField) ? new DateHistogramFieldCollectorSynchronized(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket(), ((DateHistogramGroupSource)entry.getValue()).getRounding()) : new DateHistogramFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket(), ((DateHistogramGroupSource)entry.getValue()).getRounding()));
                    continue block6;
                }
                case GEOTILE_GRID: {
                    fieldCollectors.put(entry.getKey(), new GeoTileFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket()));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("unknown type");
        }
        return fieldCollectors;
    }

    static interface FieldCollector {
        public int getMaxPageSize();

        public Collection<AggregationBuilder> aggregateChanges();

        public boolean collectChangesFromAggregations(Aggregations var1);

        public CompositeValuesSourceBuilder<?> getCompositeValueSourceBuilder();

        public boolean collectChangesFromCompositeBuckets(Collection<? extends CompositeAggregation.Bucket> var1);

        public QueryBuilder filterByChanges(long var1, long var3);

        public void clear();

        public boolean isOptimized();

        public boolean queryForChanges();
    }

    static class TermsFieldCollector
    implements FieldCollector {
        private final String sourceFieldName;
        private final String targetFieldName;
        private final boolean missingBucket;
        private final Set<String> changedTerms;
        private boolean foundNullBucket;

        TermsFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket) {
            assert (sourceFieldName != null);
            this.sourceFieldName = sourceFieldName;
            this.targetFieldName = targetFieldName;
            this.missingBucket = missingBucket;
            this.changedTerms = new HashSet<String>();
            this.foundNullBucket = false;
        }

        @Override
        public int getMaxPageSize() {
            return 65536;
        }

        @Override
        public CompositeValuesSourceBuilder<?> getCompositeValueSourceBuilder() {
            return ((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(this.targetFieldName).field(this.sourceFieldName)).missingBucket(this.missingBucket);
        }

        @Override
        public boolean collectChangesFromCompositeBuckets(Collection<? extends CompositeAggregation.Bucket> buckets) {
            this.changedTerms.clear();
            this.foundNullBucket = false;
            for (CompositeAggregation.Bucket bucket : buckets) {
                Object term = bucket.getKey().get(this.targetFieldName);
                if (term != null) {
                    this.changedTerms.add(term.toString());
                    continue;
                }
                assert (this.missingBucket);
                this.foundNullBucket = true;
            }
            return buckets.isEmpty();
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            if (this.missingBucket && this.foundNullBucket) {
                BoolQueryBuilder missingBucketQuery = new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(this.sourceFieldName));
                if (this.changedTerms.isEmpty()) {
                    return missingBucketQuery;
                }
                return new BoolQueryBuilder().should((QueryBuilder)new TermsQueryBuilder(this.sourceFieldName, this.changedTerms)).should((QueryBuilder)missingBucketQuery);
            }
            if (!this.changedTerms.isEmpty()) {
                return new TermsQueryBuilder(this.sourceFieldName, this.changedTerms);
            }
            return null;
        }

        @Override
        public void clear() {
            this.changedTerms.clear();
            this.foundNullBucket = false;
        }

        @Override
        public Collection<AggregationBuilder> aggregateChanges() {
            return Collections.emptyList();
        }

        @Override
        public boolean collectChangesFromAggregations(Aggregations aggregations) {
            return true;
        }

        @Override
        public boolean isOptimized() {
            return true;
        }

        @Override
        public boolean queryForChanges() {
            return true;
        }
    }

    static class HistogramFieldCollector
    implements FieldCollector {
        private static final double MIN_CUT_OFF = 1.2;
        private final String sourceFieldName;
        private final boolean missingBucket;
        private final double interval;
        private final Collection<AggregationBuilder> histogramFieldAggregations;
        private final String minAggregationOutputName;
        private final String maxAggregationOutputName;
        private double minLowerBound;
        private double maxUpperBound;
        private double lowerBound;
        private double upperBound;

        HistogramFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket, double interval) {
            assert (sourceFieldName != null);
            this.sourceFieldName = sourceFieldName;
            this.missingBucket = missingBucket;
            this.interval = interval;
            this.minAggregationOutputName = "_transform_change_collector." + targetFieldName + ".min";
            this.maxAggregationOutputName = "_transform_change_collector." + targetFieldName + ".max";
            this.histogramFieldAggregations = new ArrayList<AggregationBuilder>();
            this.histogramFieldAggregations.add((AggregationBuilder)AggregationBuilders.min((String)this.minAggregationOutputName).field(sourceFieldName));
            this.histogramFieldAggregations.add((AggregationBuilder)AggregationBuilders.max((String)this.maxAggregationOutputName).field(sourceFieldName));
        }

        @Override
        public int getMaxPageSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public CompositeValuesSourceBuilder<?> getCompositeValueSourceBuilder() {
            return null;
        }

        @Override
        public boolean collectChangesFromCompositeBuckets(Collection<? extends CompositeAggregation.Bucket> buckets) {
            return true;
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            if (this.missingBucket) {
                return null;
            }
            if ((this.maxUpperBound - this.minLowerBound) / (this.upperBound - this.lowerBound) < 1.2) {
                return null;
            }
            return new RangeQueryBuilder(this.sourceFieldName).gte((Object)this.lowerBound).lt((Object)this.upperBound);
        }

        @Override
        public void clear() {
        }

        @Override
        public Collection<AggregationBuilder> aggregateChanges() {
            return this.missingBucket ? Collections.emptyList() : this.histogramFieldAggregations;
        }

        @Override
        public boolean collectChangesFromAggregations(Aggregations aggregations) {
            NumericMetricsAggregation.SingleValue lowerBoundResult = (NumericMetricsAggregation.SingleValue)aggregations.get(this.minAggregationOutputName);
            NumericMetricsAggregation.SingleValue upperBoundResult = (NumericMetricsAggregation.SingleValue)aggregations.get(this.maxAggregationOutputName);
            if (lowerBoundResult != null && upperBoundResult != null) {
                this.lowerBound = this.interval * Math.floor(lowerBoundResult.value() / this.interval);
                this.upperBound = this.interval * (1.0 + Math.floor(upperBoundResult.value() / this.interval));
                this.minLowerBound = Math.min(this.minLowerBound, this.lowerBound);
                this.maxUpperBound = Math.max(this.maxUpperBound, this.upperBound);
                return false;
            }
            return true;
        }

        @Override
        public boolean isOptimized() {
            return !this.missingBucket;
        }

        @Override
        public boolean queryForChanges() {
            return !this.missingBucket;
        }
    }

    static class DateHistogramFieldCollectorSynchronized
    implements FieldCollector {
        private final String sourceFieldName;
        private final Rounding.Prepared rounding;

        DateHistogramFieldCollectorSynchronized(String sourceFieldName, String targetFieldName, boolean missingBucket, Rounding.Prepared rounding) {
            assert (sourceFieldName != null);
            assert (!missingBucket);
            this.sourceFieldName = sourceFieldName;
            this.rounding = rounding;
        }

        @Override
        public int getMaxPageSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public CompositeValuesSourceBuilder<?> getCompositeValueSourceBuilder() {
            return null;
        }

        @Override
        public boolean collectChangesFromCompositeBuckets(Collection<? extends CompositeAggregation.Bucket> buckets) {
            return true;
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            return new RangeQueryBuilder(this.sourceFieldName).gte((Object)this.rounding.round(lastCheckpointTimestamp)).format("epoch_millis");
        }

        @Override
        public void clear() {
        }

        @Override
        public Collection<AggregationBuilder> aggregateChanges() {
            return Collections.emptyList();
        }

        @Override
        public boolean collectChangesFromAggregations(Aggregations aggregations) {
            return true;
        }

        @Override
        public boolean isOptimized() {
            return true;
        }

        @Override
        public boolean queryForChanges() {
            return false;
        }
    }

    static class DateHistogramFieldCollector
    implements FieldCollector {
        private final String sourceFieldName;
        private final boolean missingBucket;
        private final Rounding.Prepared rounding;
        private final Collection<AggregationBuilder> timeFieldAggregations;
        private final String minAggregationOutputName;
        private final String maxAggregationOutputName;
        private long lowerBound;
        private long upperBound;

        DateHistogramFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket, Rounding.Prepared rounding) {
            assert (sourceFieldName != null);
            this.sourceFieldName = sourceFieldName;
            this.missingBucket = missingBucket;
            this.rounding = rounding;
            this.minAggregationOutputName = "_transform_change_collector." + targetFieldName + ".min";
            this.maxAggregationOutputName = "_transform_change_collector." + targetFieldName + ".max";
            this.timeFieldAggregations = new ArrayList<AggregationBuilder>();
            this.timeFieldAggregations.add((AggregationBuilder)AggregationBuilders.min((String)this.minAggregationOutputName).field(sourceFieldName));
            this.timeFieldAggregations.add((AggregationBuilder)AggregationBuilders.max((String)this.maxAggregationOutputName).field(sourceFieldName));
        }

        @Override
        public int getMaxPageSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public CompositeValuesSourceBuilder<?> getCompositeValueSourceBuilder() {
            return null;
        }

        @Override
        public boolean collectChangesFromCompositeBuckets(Collection<? extends CompositeAggregation.Bucket> buckets) {
            return true;
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            if (this.missingBucket) {
                return null;
            }
            return new RangeQueryBuilder(this.sourceFieldName).gte((Object)this.lowerBound).lte((Object)this.upperBound).format("epoch_millis");
        }

        @Override
        public void clear() {
        }

        @Override
        public Collection<AggregationBuilder> aggregateChanges() {
            return this.missingBucket ? Collections.emptyList() : this.timeFieldAggregations;
        }

        @Override
        public boolean collectChangesFromAggregations(Aggregations aggregations) {
            NumericMetricsAggregation.SingleValue lowerBoundResult = (NumericMetricsAggregation.SingleValue)aggregations.get(this.minAggregationOutputName);
            NumericMetricsAggregation.SingleValue upperBoundResult = (NumericMetricsAggregation.SingleValue)aggregations.get(this.maxAggregationOutputName);
            if (lowerBoundResult != null && upperBoundResult != null) {
                this.lowerBound = this.rounding.round((long)lowerBoundResult.value());
                this.upperBound = (long)upperBoundResult.value();
                return false;
            }
            return true;
        }

        @Override
        public boolean isOptimized() {
            return !this.missingBucket;
        }

        @Override
        public boolean queryForChanges() {
            return !this.missingBucket;
        }
    }

    static class GeoTileFieldCollector
    implements FieldCollector {
        private final String sourceFieldName;
        private final String targetFieldName;
        private final boolean missingBucket;
        private final Set<String> changedBuckets;
        private boolean foundNullBucket;

        GeoTileFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket) {
            assert (sourceFieldName != null);
            this.sourceFieldName = sourceFieldName;
            this.targetFieldName = targetFieldName;
            this.missingBucket = missingBucket;
            this.changedBuckets = new HashSet<String>();
            this.foundNullBucket = false;
        }

        @Override
        public int getMaxPageSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        public CompositeValuesSourceBuilder<?> getCompositeValueSourceBuilder() {
            return ((GeoTileGridValuesSourceBuilder)new GeoTileGridValuesSourceBuilder(this.targetFieldName).field(this.sourceFieldName)).missingBucket(this.missingBucket);
        }

        @Override
        public boolean collectChangesFromCompositeBuckets(Collection<? extends CompositeAggregation.Bucket> buckets) {
            this.changedBuckets.clear();
            this.foundNullBucket = false;
            for (CompositeAggregation.Bucket bucket : buckets) {
                Object bucket2 = bucket.getKey().get(this.targetFieldName);
                if (bucket2 != null) {
                    this.changedBuckets.add(bucket2.toString());
                    continue;
                }
                assert (this.missingBucket);
                this.foundNullBucket = true;
            }
            return buckets.isEmpty();
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            BoolQueryBuilder boundingBoxesQueryBuilder = null;
            if (!this.changedBuckets.isEmpty()) {
                boundingBoxesQueryBuilder = QueryBuilders.boolQuery();
                this.changedBuckets.stream().map(GeoTileUtils::toBoundingBox).map(this::toGeoQuery).forEach(arg_0 -> ((BoolQueryBuilder)boundingBoxesQueryBuilder).should(arg_0));
            }
            if (this.missingBucket && this.foundNullBucket) {
                BoolQueryBuilder missingBucketQuery = new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(this.sourceFieldName));
                if (boundingBoxesQueryBuilder == null) {
                    return missingBucketQuery;
                }
                return boundingBoxesQueryBuilder.should((QueryBuilder)missingBucketQuery);
            }
            return boundingBoxesQueryBuilder;
        }

        @Override
        public void clear() {
            this.changedBuckets.clear();
            this.foundNullBucket = false;
        }

        @Override
        public Collection<AggregationBuilder> aggregateChanges() {
            return Collections.emptyList();
        }

        @Override
        public boolean collectChangesFromAggregations(Aggregations aggregations) {
            return true;
        }

        private GeoBoundingBoxQueryBuilder toGeoQuery(Rectangle rectangle) {
            return QueryBuilders.geoBoundingBoxQuery((String)this.sourceFieldName).setCorners(new GeoPoint(rectangle.getMaxLat(), rectangle.getMinLon()), new GeoPoint(rectangle.getMinLat(), rectangle.getMaxLon()));
        }

        @Override
        public boolean isOptimized() {
            return true;
        }

        @Override
        public boolean queryForChanges() {
            return false;
        }
    }
}

