/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.ClosePointInTimeAction;
import org.elasticsearch.action.search.ClosePointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeAction;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.transforms.BulkIndexingException;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.transforms.TransformException;
import org.elasticsearch.xpack.transform.transforms.TransformIndexer;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;
import org.elasticsearch.xpack.transform.utils.ExceptionRootCauseFinder;

class ClientTransformIndexer
extends TransformIndexer {
    private static final TimeValue PIT_KEEP_ALIVE = TimeValue.timeValueSeconds((long)30L);
    private static final Logger logger = LogManager.getLogger(ClientTransformIndexer.class);
    private final Client client;
    private final AtomicBoolean oldStatsCleanedUp = new AtomicBoolean(false);
    private final AtomicReference<SeqNoPrimaryTermAndIndex> seqNoPrimaryTermAndIndex;
    private volatile PointInTimeBuilder pit;
    private volatile long pitCheckpoint;
    private volatile boolean disablePit = false;

    ClientTransformIndexer(ThreadPool threadPool, TransformServices transformServices, CheckpointProvider checkpointProvider, AtomicReference<IndexerState> initialState, TransformIndexerPosition initialPosition, Client client, TransformIndexerStats initialStats, TransformConfig transformConfig, TransformProgress transformProgress, TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, TransformContext context, boolean shouldStopAtCheckpoint) {
        super((ThreadPool)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull((Object)threadPool, (String)"threadPool"), transformServices, checkpointProvider, transformConfig, (AtomicReference)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull(initialState, (String)"initialState"), initialPosition, initialStats == null ? new TransformIndexerStats() : initialStats, transformProgress, lastCheckpoint, nextCheckpoint, context);
        this.client = (Client)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull((Object)client, (String)"client");
        this.seqNoPrimaryTermAndIndex = new AtomicReference<SeqNoPrimaryTermAndIndex>(seqNoPrimaryTermAndIndex);
        context.setShouldStopAtCheckpoint(shouldStopAtCheckpoint);
    }

    protected void doNextSearch(long waitTimeInNanos, ActionListener<SearchResponse> nextPhase) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to search while failed.", (Object)this.getJobId());
            nextPhase.onFailure((Exception)((Object)new ElasticsearchException("Attempted to do a search request for failed transform [{}].", new Object[]{this.getJobId()})));
            return;
        }
        if (this.getNextCheckpoint().getCheckpoint() != this.pitCheckpoint) {
            this.closePointInTime();
        }
        this.injectPointInTimeIfNeeded(this.buildSearchRequest(), (ActionListener<SearchRequest>)ActionListener.wrap(pitSearchRequest -> this.doSearch((SearchRequest)pitSearchRequest, nextPhase), arg_0 -> nextPhase.onFailure(arg_0)));
    }

    protected void doNextBulk(BulkRequest request, ActionListener<BulkResponse> nextPhase) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to bulk index while failed.", (Object)this.getJobId());
            nextPhase.onFailure((Exception)((Object)new ElasticsearchException("Attempted to do a bulk index request for failed transform [{}].", new Object[]{this.getJobId()})));
            return;
        }
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)BulkAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(bulkResponse -> this.handleBulkResponse((BulkResponse)bulkResponse, nextPhase), arg_0 -> nextPhase.onFailure(arg_0)));
    }

    protected void handleBulkResponse(BulkResponse bulkResponse, ActionListener<BulkResponse> nextPhase) {
        if (!bulkResponse.hasFailures()) {
            this.context.resetReasonAndFailureCounter();
            nextPhase.onResponse((Object)bulkResponse);
            return;
        }
        int failureCount = 0;
        LinkedHashMap<String, BulkItemResponse> deduplicatedFailures = new LinkedHashMap<String, BulkItemResponse>();
        for (BulkItemResponse item : bulkResponse.getItems()) {
            if (!item.isFailed()) continue;
            deduplicatedFailures.putIfAbsent(item.getFailure().getCause().getClass().getSimpleName(), item);
            ++failureCount;
        }
        Throwable irrecoverableException = ExceptionRootCauseFinder.getFirstIrrecoverableExceptionFromBulkResponses(deduplicatedFailures.values());
        if (irrecoverableException == null) {
            String failureMessage = ClientTransformIndexer.getBulkIndexDetailedFailureMessage("Significant failures: ", deduplicatedFailures);
            logger.debug("[{}] Bulk index experienced [{}] failures. {}", (Object)this.getJobId(), (Object)failureCount, (Object)failureMessage);
            Exception firstException = ((BulkItemResponse)deduplicatedFailures.values().iterator().next()).getFailure().getCause();
            nextPhase.onFailure((Exception)((Object)new BulkIndexingException("Bulk index experienced [{}] failures. {}", firstException, false, failureCount, failureMessage)));
        } else {
            deduplicatedFailures.remove(irrecoverableException.getClass().getSimpleName());
            String failureMessage = ClientTransformIndexer.getBulkIndexDetailedFailureMessage("Other failures: ", deduplicatedFailures);
            irrecoverableException = ClientTransformIndexer.decorateBulkIndexException(irrecoverableException);
            logger.debug("[{}] Bulk index experienced [{}] failures and at least 1 irrecoverable [{}]. {}", (Object)this.getJobId(), (Object)failureCount, (Object)ExceptionRootCauseFinder.getDetailedMessage(irrecoverableException), (Object)failureMessage);
            nextPhase.onFailure((Exception)((Object)new BulkIndexingException("Bulk index experienced [{}] failures and at least 1 irrecoverable [{}]. {}", irrecoverableException, true, failureCount, ExceptionRootCauseFinder.getDetailedMessage(irrecoverableException), failureMessage)));
        }
    }

    @Override
    protected void doDeleteByQuery(DeleteByQueryRequest deleteByQueryRequest, ActionListener<BulkByScrollResponse> responseListener) {
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, responseListener);
    }

    @Override
    protected void refreshDestinationIndex(ActionListener<RefreshResponse> responseListener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)RefreshAction.INSTANCE, (ActionRequest)new RefreshRequest(new String[]{this.transformConfig.getDestination().getIndex()}), responseListener);
    }

    @Override
    void doGetInitialProgress(SearchRequest request, ActionListener<SearchResponse> responseListener) {
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)request, responseListener);
    }

    @Override
    void doGetFieldMappings(ActionListener<Map<String, String>> fieldMappingsListener) {
        SchemaUtil.getDestinationFieldMappings(this.client, this.getConfig().getDestination().getIndex(), fieldMappingsListener);
    }

    @Override
    protected void persistState(TransformState state, ActionListener<Void> listener) {
        SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex = this.getSeqNoPrimaryTermAndIndex();
        this.transformsConfigManager.putOrUpdateTransformStoredDoc(new TransformStoredDoc(this.getJobId(), state, (TransformIndexerStats)this.getStats()), seqNoPrimaryTermAndIndex, (ActionListener<SeqNoPrimaryTermAndIndex>)ActionListener.wrap(r -> {
            this.updateSeqNoPrimaryTermAndIndex(seqNoPrimaryTermAndIndex, (SeqNoPrimaryTermAndIndex)r);
            if (this.oldStatsCleanedUp.compareAndSet(false, true)) {
                this.transformsConfigManager.deleteOldTransformStoredDocuments(this.getJobId(), (ActionListener<Long>)ActionListener.wrap(deletedDocs -> {
                    logger.trace("[{}] deleted old transform stats and state document, deleted: [{}] documents", (Object)this.getJobId(), deletedDocs);
                    listener.onResponse(null);
                }, e -> {
                    String msg = LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)this.getJobId(), (Object[])new Object[0]);
                    logger.warn(msg, (Throwable)e);
                    this.oldStatsCleanedUp.set(false);
                    listener.onResponse(null);
                }));
            } else {
                listener.onResponse(null);
            }
        }, statsExc -> {
            if (ExceptionsHelper.unwrapCause((Throwable)statsExc) instanceof VersionConflictEngineException) {
                logger.error((Message)new ParameterizedMessage("[{}] updating stats of transform failed, unexpected version conflict of internal state, resetting to recover.", (Object)this.transformConfig.getId()), (Throwable)statsExc);
                this.auditor.warning(this.getJobId(), "Failure updating stats of transform, unexpected version conflict of internal state, resetting to recover: " + statsExc.getMessage());
                assert (false) : "[" + this.getJobId() + "] updating stats of transform failed, unexpected version conflict of internal state";
            } else {
                logger.error((Message)new ParameterizedMessage("[{}] updating stats of transform failed.", (Object)this.transformConfig.getId()), (Throwable)statsExc);
                this.auditor.warning(this.getJobId(), "Failure updating stats of transform: " + statsExc.getMessage());
            }
            listener.onFailure(statsExc);
        }));
    }

    void updateSeqNoPrimaryTermAndIndex(SeqNoPrimaryTermAndIndex expectedValue, SeqNoPrimaryTermAndIndex newValue) {
        logger.debug(() -> new ParameterizedMessage("[{}] Updated state document from [{}] to [{}]", new Object[]{this.transformConfig.getId(), expectedValue, newValue}));
        boolean updated = this.seqNoPrimaryTermAndIndex.compareAndSet(expectedValue, newValue);
        if (!updated) {
            logger.warn("[{}] Unexpected change to internal state detected, expected [{}], got [{}]", (Object)this.transformConfig.getId(), (Object)expectedValue, (Object)this.seqNoPrimaryTermAndIndex.get());
            assert (updated) : "[" + this.getJobId() + "] unexpected change to seqNoPrimaryTermAndIndex.";
        }
    }

    @Nullable
    SeqNoPrimaryTermAndIndex getSeqNoPrimaryTermAndIndex() {
        return this.seqNoPrimaryTermAndIndex.get();
    }

    @Override
    protected void afterFinishOrFailure() {
        this.closePointInTime();
        super.afterFinishOrFailure();
    }

    @Override
    protected void onStop() {
        this.closePointInTime();
        super.onStop();
    }

    private void closePointInTime() {
        if (this.pit == null) {
            return;
        }
        String oldPit = this.pit.getEncodedId();
        this.pit = null;
        ClosePointInTimeRequest closePitRequest = new ClosePointInTimeRequest(oldPit);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)ClosePointInTimeAction.INSTANCE, (ActionRequest)closePitRequest, (ActionListener)ActionListener.wrap(response -> logger.trace("[{}] closed pit search context [{}]", (Object)this.getJobId(), (Object)oldPit), e -> logger.error((Message)new ParameterizedMessage("[{}] Failed to close point in time reader", (Object)this.getJobId()), (Throwable)e)));
    }

    private void injectPointInTimeIfNeeded(SearchRequest searchRequest, ActionListener<SearchRequest> listener) {
        if (this.disablePit) {
            listener.onResponse((Object)searchRequest);
            return;
        }
        if (this.pit != null) {
            searchRequest.source().pointInTimeBuilder(this.pit);
            listener.onResponse((Object)searchRequest);
            return;
        }
        OpenPointInTimeRequest pitRequest = new OpenPointInTimeRequest(this.transformConfig.getSource().getIndex()).keepAlive(PIT_KEEP_ALIVE);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)OpenPointInTimeAction.INSTANCE, (ActionRequest)pitRequest, (ActionListener)ActionListener.wrap(response -> {
            this.pit = new PointInTimeBuilder(response.getPointInTimeId()).setKeepAlive(PIT_KEEP_ALIVE);
            searchRequest.source().pointInTimeBuilder(this.pit);
            this.pitCheckpoint = this.getNextCheckpoint().getCheckpoint();
            logger.trace("[{}] using pit search context with id [{}]", (Object)this.getJobId(), (Object)this.pit.getEncodedId());
            listener.onResponse((Object)searchRequest);
        }, e -> {
            Throwable unwrappedException = org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.findSearchExceptionRootCause((Throwable)e);
            if (unwrappedException instanceof ActionNotFoundTransportException) {
                logger.warn("[{}] source does not support point in time reader, falling back to normal search (more resource intensive)", (Object)this.getJobId());
                this.auditor.warning(this.getJobId(), "Source does not support point in time reader, falling back to normal search (more resource intensive)");
                this.disablePit = true;
            } else {
                logger.warn((Message)new ParameterizedMessage("[{}] Failed to create a point in time reader, falling back to normal search.", (Object)this.getJobId()), (Throwable)e);
            }
            listener.onResponse((Object)searchRequest);
        }));
    }

    private void doSearch(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        logger.trace("searchRequest: {}", (Object)searchRequest);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.pointInTimeId() != null && (this.pit == null || response.pointInTimeId() != this.pit.getEncodedId())) {
                this.pit = new PointInTimeBuilder(response.pointInTimeId()).setKeepAlive(PIT_KEEP_ALIVE);
                logger.trace("point in time handle has changed");
            }
            listener.onResponse(response);
        }, e -> {
            Throwable unwrappedException = org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.findSearchExceptionRootCause((Throwable)e);
            if (unwrappedException instanceof SearchContextMissingException) {
                logger.warn((Message)new ParameterizedMessage("[{}] Search context missing, falling back to normal search.", (Object)this.getJobId()), (Throwable)e);
                this.pit = null;
                searchRequest.source().pointInTimeBuilder(null);
                ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)listener);
                return;
            }
            listener.onFailure(e);
        }));
    }

    private static String getBulkIndexDetailedFailureMessage(String prefix, Map<String, BulkItemResponse> failures) {
        if (failures.isEmpty()) {
            return "";
        }
        StringBuilder failureMessageBuilder = new StringBuilder(prefix);
        for (Map.Entry<String, BulkItemResponse> failure : failures.entrySet()) {
            failureMessageBuilder.append("\n[").append(failure.getKey()).append("] message [").append(failure.getValue().getFailureMessage()).append("]");
        }
        String failureMessage = failureMessageBuilder.toString();
        return failureMessage;
    }

    private static Throwable decorateBulkIndexException(Throwable irrecoverableException) {
        if (irrecoverableException instanceof MapperParsingException) {
            return new TransformException("Destination index mappings are incompatible with the transform configuration.", irrecoverableException, new Object[0]);
        }
        return irrecoverableException;
    }
}

