/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.v2;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.OfflineSorter;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.xpack.rollup.v2.CompressingOfflineSorter;

class XExternalRefSorter
implements BytesRefSorter,
Closeable {
    private final CompressingOfflineSorter sorter;
    private CompressingOfflineSorter.Writer writer;
    private IndexOutput input;
    private String sortedFileName;

    XExternalRefSorter(CompressingOfflineSorter sorter) throws IOException {
        this.sorter = sorter;
        this.input = sorter.getDirectory().createTempOutput(sorter.getTempFileNamePrefix(), "RefSorterRaw", IOContext.DEFAULT);
        this.writer = sorter.getWriter(this.input, -1L);
    }

    public void add(BytesRef utf8) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException();
        }
        this.writer.write(utf8);
    }

    public BytesRefIterator iterator() throws IOException {
        block5: {
            block6: {
                block4: {
                    if (this.sortedFileName != null) break block5;
                    this.closeWriter();
                    boolean success = false;
                    try {
                        this.sortedFileName = this.sorter.sort(this.input.getName());
                        success = true;
                        if (!success) break block4;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            this.sorter.getDirectory().deleteFile(this.input.getName());
                        } else {
                            XExternalRefSorter.deleteFilesIgnoringExceptions(this.sorter.getDirectory(), this.input.getName());
                        }
                        throw throwable;
                    }
                    this.sorter.getDirectory().deleteFile(this.input.getName());
                    break block6;
                }
                XExternalRefSorter.deleteFilesIgnoringExceptions(this.sorter.getDirectory(), this.input.getName());
            }
            this.input = null;
        }
        OfflineSorter.ByteSequencesReader reader = this.sorter.getReader(this.sorter.getDirectory().openChecksumInput(this.sortedFileName, IOContext.READONCE), this.sortedFileName);
        return new ByteSequenceIterator(reader);
    }

    private void closeWriter() throws IOException {
        if (this.writer != null) {
            CodecUtil.writeFooter((IndexOutput)this.writer.out);
            this.writer.close();
            this.writer = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        try {
            this.closeWriter();
            if (this.input != null) return;
        }
        catch (Throwable throwable) {
            if (this.input != null) throw throwable;
            XExternalRefSorter.deleteFilesIgnoringExceptions(this.sorter.getDirectory(), this.input == null ? null : this.input.getName(), this.sortedFileName);
            throw throwable;
        }
        XExternalRefSorter.deleteFilesIgnoringExceptions(this.sorter.getDirectory(), this.input == null ? null : this.input.getName(), this.sortedFileName);
    }

    public Comparator<BytesRef> getComparator() {
        return this.sorter.getComparator();
    }

    private static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        for (String name : files) {
            if (name == null) continue;
            try {
                dir.deleteFile(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class ByteSequenceIterator
    implements BytesRefIterator {
        private final OfflineSorter.ByteSequencesReader reader;
        private BytesRef scratch;

        ByteSequenceIterator(OfflineSorter.ByteSequencesReader reader) {
            this.reader = reader;
        }

        public BytesRef next() throws IOException {
            boolean success = false;
            try {
                this.scratch = this.reader.next();
                if (this.scratch == null) {
                    this.reader.close();
                }
                success = true;
                BytesRef bytesRef = this.scratch;
                return bytesRef;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable)this.reader);
                }
            }
        }
    }
}

