/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.v2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.xpack.core.rollup.job.MetricConfig;

class FieldMetricsProducer {
    final String fieldName;
    final List<Metric> metrics;

    FieldMetricsProducer(String fieldName, List<Metric> metrics) {
        this.fieldName = fieldName;
        this.metrics = metrics;
    }

    void reset() {
        for (Metric metric : this.metrics) {
            metric.reset();
        }
    }

    static List<FieldMetricsProducer> buildMetrics(List<MetricConfig> metricsConfigs) {
        ArrayList<FieldMetricsProducer> fields = new ArrayList<FieldMetricsProducer>();
        if (metricsConfigs != null) {
            for (MetricConfig metricConfig : metricsConfigs) {
                List<String> normalizedMetrics = FieldMetricsProducer.normalizeMetrics(metricConfig.getMetrics());
                ArrayList<Metric> list = new ArrayList<Metric>();
                if (normalizedMetrics.isEmpty()) continue;
                Iterator<String> iterator = normalizedMetrics.iterator();
                block13: while (iterator.hasNext()) {
                    String metricName;
                    switch (metricName = iterator.next()) {
                        case "min": {
                            list.add(new Min());
                            continue block13;
                        }
                        case "max": {
                            list.add(new Max());
                            continue block13;
                        }
                        case "sum": {
                            list.add(new Sum());
                            continue block13;
                        }
                        case "value_count": {
                            list.add(new ValueCount());
                            continue block13;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported metric type [" + metricName + "]");
                }
                fields.add(new FieldMetricsProducer(metricConfig.getField(), Collections.unmodifiableList(list)));
            }
        }
        return Collections.unmodifiableList(fields);
    }

    static List<String> normalizeMetrics(List<String> metrics) {
        ArrayList<String> newMetrics = new ArrayList<String>(metrics);
        if (newMetrics.remove(MetricConfig.AVG.getPreferredName())) {
            if (!newMetrics.contains(MetricConfig.VALUE_COUNT.getPreferredName())) {
                newMetrics.add(MetricConfig.VALUE_COUNT.getPreferredName());
            }
            if (!newMetrics.contains(MetricConfig.SUM.getPreferredName())) {
                newMetrics.add(MetricConfig.SUM.getPreferredName());
            }
        }
        return newMetrics;
    }

    static abstract class Metric {
        final String name;

        protected Metric(String name) {
            this.name = name;
        }

        abstract void collect(double var1);

        abstract Number get();

        abstract void reset();
    }

    private static class Min
    extends Metric {
        private Double min;

        private Min() {
            super("min");
        }

        @Override
        void collect(double value) {
            this.min = this.min != null ? Math.min(value, this.min) : value;
        }

        @Override
        Number get() {
            return this.min;
        }

        @Override
        void reset() {
            this.min = null;
        }
    }

    private static class Max
    extends Metric {
        private Double max;

        Max() {
            super("max");
        }

        @Override
        void collect(double value) {
            this.max = this.max != null ? Math.max(value, this.max) : value;
        }

        @Override
        Number get() {
            return this.max;
        }

        @Override
        void reset() {
            this.max = null;
        }
    }

    private static class Sum
    extends Metric {
        private double sum = 0.0;

        private Sum() {
            super("sum");
        }

        @Override
        void collect(double value) {
            this.sum += value;
        }

        @Override
        Number get() {
            return this.sum;
        }

        @Override
        void reset() {
            this.sum = 0.0;
        }
    }

    private static class ValueCount
    extends Metric {
        private long count;

        private ValueCount() {
            super("value_count");
        }

        @Override
        void collect(double value) {
            ++this.count;
        }

        @Override
        Number get() {
            return this.count;
        }

        @Override
        void reset() {
            this.count = 0L;
        }
    }
}

