/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ccr.CcrAutoFollowInfoFetcher;
import org.elasticsearch.xpack.deprecation.DeprecationChecker;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;

public class CcrAutoFollowedSystemIndicesChecker
implements DeprecationChecker {
    @Override
    public boolean enabled(Settings settings) {
        return (Boolean)XPackSettings.CCR_ENABLED_SETTING.get(settings);
    }

    @Override
    public void check(DeprecationChecker.Components components, ActionListener<DeprecationChecker.CheckResult> deprecationIssueListener) {
        CcrAutoFollowInfoFetcher.getAutoFollowedSystemIndices((Client)components.client(), (ClusterState)components.clusterState(), (ActionListener)deprecationIssueListener.map(autoFollowedSystemIndices -> {
            List<DeprecationIssue> deprecationIssues = autoFollowedSystemIndices.stream().map(this::createDeprecationIssue).collect(Collectors.toList());
            return new DeprecationChecker.CheckResult(this.getName(), deprecationIssues);
        }));
    }

    private DeprecationIssue createDeprecationIssue(String localIndexName) {
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "An auto followed index follows a remote system index", "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/migrating-7.14.html#breaking_714_ccr_changes", "Auto followed index [" + localIndexName + "] follows a remote system index and this behaviour will change in the next major version.", false, null);
    }

    @Override
    public String getName() {
        return "ccr_auto_followed_system_indices";
    }
}

