/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class StreamFileValuePatternReaderThread
extends Thread {
    private final AtomicLong nextReadPosition;
    private final AtomicReference<StreamFileValuePatternReaderThread> threadRef;
    private final LinkedBlockingQueue<String> lineQueue;
    private final long maxOfferBlockTimeMillis;
    private final RandomAccessFile randomAccessFile;

    StreamFileValuePatternReaderThread(File file, LinkedBlockingQueue<String> lineQueue, long maxOfferBlockTimeMillis, AtomicLong nextReadPosition, AtomicReference<StreamFileValuePatternReaderThread> threadRef) throws IOException {
        this.setName("StreamFileValuePatternReaderThread for file '" + file.getAbsolutePath() + '\'');
        this.setDaemon(true);
        this.lineQueue = lineQueue;
        this.maxOfferBlockTimeMillis = maxOfferBlockTimeMillis;
        this.nextReadPosition = nextReadPosition;
        this.threadRef = threadRef;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.randomAccessFile.seek(nextReadPosition.get());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                String line;
                if ((line = this.randomAccessFile.readLine()) == null) {
                    this.nextReadPosition.set(0L);
                    return;
                }
                if (!this.lineQueue.offer(line, this.maxOfferBlockTimeMillis, TimeUnit.MILLISECONDS)) return;
                this.nextReadPosition.set(this.randomAccessFile.getFilePointer());
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.nextReadPosition.set(0L);
            return;
        }
        finally {
            this.threadRef.set(null);
            try {
                this.randomAccessFile.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }
}

