/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TransformProgress
implements Writeable,
ToXContentObject {
    public static final ParseField TOTAL_DOCS = new ParseField("total_docs", new String[0]);
    public static final ParseField DOCS_REMAINING = new ParseField("docs_remaining", new String[0]);
    public static final ParseField DOCS_PROCESSED = new ParseField("docs_processed", new String[0]);
    public static final ParseField DOCS_INDEXED = new ParseField("docs_indexed", new String[0]);
    public static final String PERCENT_COMPLETE = "percent_complete";
    public static final ConstructingObjectParser<TransformProgress, Void> PARSER = new ConstructingObjectParser("data_frame_transform_progress", true, a -> new TransformProgress((Long)a[0], (Long)a[1], (Long)a[2], (Long)a[3]));
    private final Long totalDocs;
    private long documentsProcessed;
    private long documentsIndexed;

    public TransformProgress() {
        this(null, 0L, 0L);
    }

    public TransformProgress(Long totalDocs, Long docsRemaining, Long documentsProcessed, Long documentsIndexed) {
        this(totalDocs, documentsProcessed != null ? documentsProcessed : (docsRemaining != null && totalDocs != null ? totalDocs - docsRemaining : 0L), documentsIndexed);
    }

    public TransformProgress(Long totalDocs, Long documentsProcessed, Long documentsIndexed) {
        if (totalDocs != null && totalDocs < 0L) {
            throw new IllegalArgumentException("[total_docs] must be >0.");
        }
        this.totalDocs = totalDocs;
        if (documentsProcessed != null && documentsProcessed < 0L) {
            throw new IllegalArgumentException("[docs_processed] must be >0.");
        }
        long l = this.documentsProcessed = documentsProcessed == null ? 0L : documentsProcessed;
        if (documentsIndexed != null && documentsIndexed < 0L) {
            throw new IllegalArgumentException("[docs_indexed] must be >0.");
        }
        this.documentsIndexed = documentsIndexed == null ? 0L : documentsIndexed;
    }

    public TransformProgress(TransformProgress otherProgress) {
        this.totalDocs = otherProgress.totalDocs;
        this.documentsProcessed = otherProgress.documentsProcessed;
        this.documentsIndexed = otherProgress.documentsIndexed;
    }

    public TransformProgress(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_7_4_0)) {
            this.totalDocs = in.readOptionalLong();
            this.documentsProcessed = in.readVLong();
            this.documentsIndexed = in.readVLong();
        } else {
            this.totalDocs = in.readLong();
            long remainingDocs = in.readLong();
            this.documentsProcessed = this.totalDocs - remainingDocs;
            this.documentsIndexed = 0L;
        }
    }

    public Double getPercentComplete() {
        if (this.totalDocs == null) {
            return null;
        }
        if (this.documentsProcessed >= this.totalDocs) {
            return 100.0;
        }
        return 100.0 * (double)this.documentsProcessed / (double)this.totalDocs.longValue();
    }

    public Long getTotalDocs() {
        return this.totalDocs;
    }

    public void incrementDocsProcessed(long docsProcessed) {
        assert (docsProcessed >= 0L);
        this.documentsProcessed += docsProcessed;
    }

    public void incrementDocsIndexed(long documentsIndexed) {
        assert (documentsIndexed >= 0L);
        this.documentsIndexed += documentsIndexed;
    }

    public long getDocumentsProcessed() {
        return this.documentsProcessed;
    }

    public long getDocumentsIndexed() {
        return this.documentsIndexed;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        TransformProgress that = (TransformProgress)other;
        return Objects.equals(this.documentsIndexed, that.documentsIndexed) && Objects.equals(this.totalDocs, that.totalDocs) && Objects.equals(this.documentsProcessed, that.documentsProcessed);
    }

    public int hashCode() {
        return Objects.hash(this.documentsProcessed, this.documentsIndexed, this.totalDocs);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeOptionalLong(this.totalDocs);
            out.writeVLong(this.documentsProcessed);
            out.writeVLong(this.documentsIndexed);
        } else {
            long unboxedTotalDocs = this.totalDocs == null ? 0L : this.totalDocs;
            out.writeLong(unboxedTotalDocs);
            out.writeLong(unboxedTotalDocs < this.documentsProcessed ? 0L : unboxedTotalDocs - this.documentsProcessed);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.totalDocs != null) {
            builder.field(DOCS_REMAINING.getPreferredName(), this.documentsProcessed > this.totalDocs ? 0L : this.totalDocs - this.documentsProcessed);
            builder.field(TOTAL_DOCS.getPreferredName(), this.totalDocs);
            builder.field(PERCENT_COMPLETE, this.getPercentComplete());
        }
        builder.field(DOCS_INDEXED.getPreferredName(), this.documentsIndexed);
        builder.field(DOCS_PROCESSED.getPreferredName(), this.documentsProcessed);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TOTAL_DOCS);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCS_REMAINING);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCS_PROCESSED);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCS_INDEXED);
    }
}

