/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.CertificateTrustRestrictions;
import org.elasticsearch.xpack.core.ssl.RestrictedTrustManager;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public final class RestrictedTrustConfig
extends TrustConfig {
    private static final String RESTRICTIONS_KEY_SUBJECT_NAME = "trust.subject_name";
    private final String groupConfigPath;
    private final TrustConfig delegate;

    RestrictedTrustConfig(String groupConfigPath, TrustConfig delegate) {
        this.groupConfigPath = Objects.requireNonNull(groupConfigPath);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    RestrictedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            X509ExtendedTrustManager delegateTrustManager = this.delegate.createTrustManager(environment);
            CertificateTrustRestrictions trustGroupConfig = this.readTrustGroup(this.resolveGroupConfigPath(environment));
            return new RestrictedTrustManager(delegateTrustManager, trustGroupConfig);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to initialize TrustManager for {}", (Throwable)e, this.toString());
        }
    }

    @Override
    Collection<CertificateInfo> certificates(Environment environment) throws GeneralSecurityException, IOException {
        return this.delegate.certificates(environment);
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        return CollectionUtils.appendToCopy(this.delegate.filesToMonitor(environment), this.resolveGroupConfigPath(environment));
    }

    @Override
    public String toString() {
        return "restrictedTrust=[" + this.groupConfigPath + ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedTrustConfig that = (RestrictedTrustConfig)o;
        return this.groupConfigPath.equals(that.groupConfigPath) && this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        int result = this.groupConfigPath.hashCode();
        result = 31 * result + this.delegate.hashCode();
        return result;
    }

    private Path resolveGroupConfigPath(@Nullable Environment environment) {
        return CertParsingUtils.resolvePath(this.groupConfigPath, environment);
    }

    private CertificateTrustRestrictions readTrustGroup(Path path) throws IOException {
        Settings settings = Settings.builder().loadFromPath(path).build();
        List<String> trustNodeNames = settings.getAsList(RESTRICTIONS_KEY_SUBJECT_NAME);
        return new CertificateTrustRestrictions(trustNodeNames);
    }
}

