/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PhaseProgress
implements ToXContentObject,
Writeable {
    public static final ParseField PHASE = new ParseField("phase", new String[0]);
    public static final ParseField PROGRESS_PERCENT = new ParseField("progress_percent", new String[0]);
    public static final ConstructingObjectParser<PhaseProgress, Void> PARSER = new ConstructingObjectParser("phase_progress", true, a -> new PhaseProgress((String)a[0], (Integer)a[1]));
    private final String phase;
    private final int progressPercent;

    public PhaseProgress(String phase, int progressPercent) {
        this.phase = Objects.requireNonNull(phase);
        this.progressPercent = progressPercent;
    }

    public PhaseProgress(StreamInput in) throws IOException {
        this.phase = in.readString();
        this.progressPercent = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.phase);
        out.writeVInt(this.progressPercent);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PHASE.getPreferredName(), this.phase);
        builder.field(PROGRESS_PERCENT.getPreferredName(), this.progressPercent);
        builder.endObject();
        return builder;
    }

    public String getPhase() {
        return this.phase;
    }

    public int getProgressPercent() {
        return this.progressPercent;
    }

    public int hashCode() {
        return Objects.hash(this.phase, this.progressPercent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhaseProgress that = (PhaseProgress)o;
        return Objects.equals(this.phase, that.phase) && this.progressPercent == that.progressPercent;
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PHASE);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), PROGRESS_PERCENT);
    }
}

