/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FilterRef
implements ToXContentObject,
Writeable {
    public static final ParseField FILTER_REF_FIELD = new ParseField("filter_ref", new String[0]);
    public static final ParseField FILTER_ID = new ParseField("filter_id", new String[0]);
    public static final ParseField FILTER_TYPE = new ParseField("filter_type", new String[0]);
    public static final ConstructingObjectParser<FilterRef, Void> LENIENT_PARSER = FilterRef.createParser(true);
    public static final ConstructingObjectParser<FilterRef, Void> STRICT_PARSER = FilterRef.createParser(false);
    private final String filterId;
    private final FilterType filterType;

    private static ConstructingObjectParser<FilterRef, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<FilterRef, Void> parser = new ConstructingObjectParser<FilterRef, Void>(FILTER_REF_FIELD.getPreferredName(), ignoreUnknownFields, a -> new FilterRef((String)a[0], (FilterType)((Object)((Object)a[1]))));
        parser.declareString(ConstructingObjectParser.constructorArg(), FILTER_ID);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), FilterType::fromString, FILTER_TYPE);
        return parser;
    }

    public FilterRef(String filterId, FilterType filterType) {
        this.filterId = Objects.requireNonNull(filterId);
        this.filterType = filterType == null ? FilterType.INCLUDE : filterType;
    }

    public FilterRef(StreamInput in) throws IOException {
        this.filterId = in.readString();
        this.filterType = in.readEnum(FilterType.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.filterId);
        out.writeEnum(this.filterType);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FILTER_ID.getPreferredName(), this.filterId);
        builder.field(FILTER_TYPE.getPreferredName(), (Object)this.filterType);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterRef)) {
            return false;
        }
        FilterRef other = (FilterRef)obj;
        return Objects.equals(this.filterId, other.filterId) && Objects.equals((Object)this.filterType, (Object)other.filterType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterId, this.filterType});
    }

    public String getFilterId() {
        return this.filterId;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public static enum FilterType {
        INCLUDE,
        EXCLUDE;


        public static FilterType fromString(String value) {
            return FilterType.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

