/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetCategoriesAction
extends ActionType<Response> {
    public static final GetCategoriesAction INSTANCE = new GetCategoriesAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/categories/get";

    private GetCategoriesAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<CategoryDefinition>
    implements ToXContentObject {
        public Response(QueryPage<CategoryDefinition> result) {
            super(result);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public QueryPage<CategoryDefinition> getResult() {
            return this.getResources();
        }

        @Override
        protected Writeable.Reader<CategoryDefinition> getReader() {
            return CategoryDefinition::new;
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client, GetCategoriesAction action) {
            super(client, action, new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField CATEGORY_ID = CategoryDefinition.CATEGORY_ID;
        public static final ParseField FROM = new ParseField("from", new String[0]);
        public static final ParseField SIZE = new ParseField("size", new String[0]);
        public static final ParseField PARTITION_FIELD_VALUE = CategoryDefinition.PARTITION_FIELD_VALUE;
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/categories/get", Request::new);
        private String jobId;
        private Long categoryId;
        private PageParams pageParams;
        private String partitionFieldValue;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.categoryId = in.readOptionalLong();
            this.pageParams = in.readOptionalWriteable(PageParams::new);
            if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
                this.partitionFieldValue = in.readOptionalString();
            }
        }

        public String getJobId() {
            return this.jobId;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public Long getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(Long categoryId) {
            if (this.pageParams != null) {
                throw new IllegalArgumentException("Param [" + CATEGORY_ID.getPreferredName() + "] is incompatible with [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "].");
            }
            this.categoryId = ExceptionsHelper.requireNonNull(categoryId, CATEGORY_ID.getPreferredName());
        }

        public void setPageParams(PageParams pageParams) {
            if (this.categoryId != null) {
                throw new IllegalArgumentException("Param [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] is incompatible with [" + CATEGORY_ID.getPreferredName() + "].");
            }
            this.pageParams = pageParams;
        }

        public String getPartitionFieldValue() {
            return this.partitionFieldValue;
        }

        public void setPartitionFieldValue(String partitionFieldValue) {
            this.partitionFieldValue = partitionFieldValue;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.pageParams == null && this.categoryId == null) {
                validationException = ValidateActions.addValidationError("Both [" + CATEGORY_ID.getPreferredName() + "] and [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] cannot be null", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeOptionalLong(this.categoryId);
            out.writeOptionalWriteable(this.pageParams);
            if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
                out.writeOptionalString(this.partitionFieldValue);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            if (this.categoryId != null) {
                builder.field(CATEGORY_ID.getPreferredName(), this.categoryId);
            }
            if (this.pageParams != null) {
                builder.field(PageParams.PAGE.getPreferredName(), this.pageParams);
            }
            if (this.partitionFieldValue != null) {
                builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.categoryId, request.categoryId) && Objects.equals(this.pageParams, request.pageParams) && Objects.equals(this.partitionFieldValue, request.partitionFieldValue);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.categoryId, this.pageParams, this.partitionFieldValue);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareLong(Request::setCategoryId, CATEGORY_ID);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
            PARSER.declareString(Request::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        }
    }
}

