/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FinalizeJobExecutionAction
extends ActionType<AcknowledgedResponse> {
    public static final FinalizeJobExecutionAction INSTANCE = new FinalizeJobExecutionAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/finalize_job_execution";

    private FinalizeJobExecutionAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, AcknowledgedResponse, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, FinalizeJobExecutionAction action) {
            super(client, action, new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String[] jobIds;

        public Request(String[] jobIds) {
            this.jobIds = jobIds;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobIds = in.readStringArray();
        }

        public String[] getJobIds() {
            return this.jobIds;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.jobIds);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

