/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;

public class MigrateToDataTiersResponse
extends ActionResponse
implements ToXContentObject {
    public static final ParseField REMOVED_LEGACY_TEMPLATE = new ParseField("removed_legacy_template", new String[0]);
    public static final ParseField MIGRATED_INDICES = new ParseField("migrated_indices", new String[0]);
    public static final ParseField MIGRATED_ILM_POLICIES = new ParseField("migrated_ilm_policies", new String[0]);
    private static final ParseField DRY_RUN = new ParseField("dry_run", new String[0]);
    @Nullable
    private final String removedIndexTemplateName;
    private final List<String> migratedPolicies;
    private final List<String> migratedIndices;
    private final boolean dryRun;

    public MigrateToDataTiersResponse(@Nullable String removedIndexTemplateName, List<String> migratedPolicies, List<String> migratedIndices, boolean dryRun) {
        this.removedIndexTemplateName = removedIndexTemplateName;
        this.migratedPolicies = migratedPolicies;
        this.migratedIndices = migratedIndices;
        this.dryRun = dryRun;
    }

    public MigrateToDataTiersResponse(StreamInput in) throws IOException {
        super(in);
        this.removedIndexTemplateName = in.readOptionalString();
        this.migratedPolicies = in.readStringList();
        this.migratedIndices = in.readStringList();
        this.dryRun = in.readBoolean();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DRY_RUN.getPreferredName(), this.dryRun);
        if (this.removedIndexTemplateName != null) {
            builder.field(REMOVED_LEGACY_TEMPLATE.getPreferredName(), this.removedIndexTemplateName);
        }
        if (this.migratedPolicies.size() > 0) {
            builder.startArray(MIGRATED_ILM_POLICIES.getPreferredName());
            for (String policy : this.migratedPolicies) {
                builder.value(policy);
            }
            builder.endArray();
        }
        if (this.migratedIndices.size() > 0) {
            builder.startArray(MIGRATED_INDICES.getPreferredName());
            for (String index : this.migratedIndices) {
                builder.value(index);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public String getRemovedIndexTemplateName() {
        return this.removedIndexTemplateName;
    }

    public List<String> getMigratedPolicies() {
        return this.migratedPolicies;
    }

    public List<String> getMigratedIndices() {
        return this.migratedIndices;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.removedIndexTemplateName);
        out.writeStringCollection(this.migratedPolicies);
        out.writeStringCollection(this.migratedIndices);
        out.writeBoolean(this.dryRun);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrateToDataTiersResponse that = (MigrateToDataTiersResponse)o;
        return this.dryRun == that.dryRun && Objects.equals(this.removedIndexTemplateName, that.removedIndexTemplateName) && Objects.equals(this.migratedPolicies, that.migratedPolicies) && Objects.equals(this.migratedIndices, that.migratedIndices);
    }

    public int hashCode() {
        return Objects.hash(this.removedIndexTemplateName, this.migratedPolicies, this.migratedIndices, this.dryRun);
    }
}

