/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.Config;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioGroup;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.nio.NioGroupFactory;
import org.elasticsearch.transport.nio.NioTcpChannel;
import org.elasticsearch.transport.nio.NioTcpServerChannel;
import org.elasticsearch.transport.nio.PageAllocator;
import org.elasticsearch.transport.nio.TcpReadWriteHandler;

public class NioTransport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(NioTransport.class);
    protected final PageAllocator pageAllocator;
    private final ConcurrentMap<String, TcpChannelFactory> profileToChannelFactory = ConcurrentCollections.newConcurrentMap();
    private final NioGroupFactory groupFactory;
    private volatile NioGroup nioGroup;
    private volatile Function<DiscoveryNode, TcpChannelFactory> clientChannelFactory;

    protected NioTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, NioGroupFactory groupFactory) {
        super(settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        this.pageAllocator = new PageAllocator(pageCacheRecycler);
        this.groupFactory = groupFactory;
    }

    @Override
    protected NioTcpServerChannel bind(String name, InetSocketAddress address) throws IOException {
        TcpChannelFactory channelFactory = (TcpChannelFactory)this.profileToChannelFactory.get(name);
        NioTcpServerChannel serverChannel = this.nioGroup.bindServerChannel(address, channelFactory);
        PlainActionFuture future = PlainActionFuture.newFuture();
        serverChannel.addBindListener(ActionListener.toBiConsumer(future));
        future.actionGet();
        return serverChannel;
    }

    @Override
    protected NioTcpChannel initiateChannel(DiscoveryNode node) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        return (NioTcpChannel)this.nioGroup.openChannel(address, this.clientChannelFactory.apply(node));
    }

    @Override
    protected void doStart() {
        boolean success = false;
        try {
            this.nioGroup = this.groupFactory.getTransportGroup();
            TcpTransport.ProfileSettings clientProfileSettings = new TcpTransport.ProfileSettings(this.settings, "default");
            this.clientChannelFactory = this.clientChannelFactoryFunction(clientProfileSettings);
            if (NetworkService.NETWORK_SERVER.get(this.settings).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    String profileName = profileSettings.profileName;
                    TcpChannelFactory factory = this.serverChannelFactory(profileSettings);
                    this.profileToChannelFactory.putIfAbsent(profileName, factory);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        catch (IOException e) {
            throw new ElasticsearchException(e);
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    @Override
    protected void stopInternal() {
        try {
            this.nioGroup.close();
        }
        catch (Exception e) {
            logger.warn("unexpected exception while stopping nio group", (Throwable)e);
        }
        this.profileToChannelFactory.clear();
    }

    protected void acceptChannel(NioSocketChannel channel) {
        this.serverAcceptedChannel((NioTcpChannel)channel);
    }

    protected TcpChannelFactory serverChannelFactory(TcpTransport.ProfileSettings profileSettings) {
        return new TcpChannelFactoryImpl(profileSettings, false);
    }

    protected Function<DiscoveryNode, TcpChannelFactory> clientChannelFactoryFunction(TcpTransport.ProfileSettings profileSettings) {
        return n -> new TcpChannelFactoryImpl(profileSettings, true);
    }

    protected static abstract class TcpChannelFactory
    extends ChannelFactory<NioTcpServerChannel, NioTcpChannel> {
        protected TcpChannelFactory(TcpTransport.ProfileSettings profileSettings) {
            super(profileSettings.tcpNoDelay, profileSettings.tcpKeepAlive, profileSettings.tcpKeepIdle, profileSettings.tcpKeepInterval, profileSettings.tcpKeepCount, profileSettings.reuseAddress, Math.toIntExact(profileSettings.sendBufferSize.getBytes()), Math.toIntExact(profileSettings.receiveBufferSize.getBytes()));
        }
    }

    private class TcpChannelFactoryImpl
    extends TcpChannelFactory {
        private final boolean isClient;
        private final String profileName;

        private TcpChannelFactoryImpl(TcpTransport.ProfileSettings profileSettings, boolean isClient) {
            super(profileSettings);
            this.isClient = isClient;
            this.profileName = profileSettings.profileName;
        }

        @Override
        public NioTcpChannel createChannel(NioSelector selector, SocketChannel channel, Config.Socket socketConfig) {
            NioTcpChannel nioChannel = new NioTcpChannel(!this.isClient, this.profileName, channel);
            Consumer<Exception> exceptionHandler = e -> NioTransport.this.onException(nioChannel, (Exception)e);
            TcpReadWriteHandler handler = new TcpReadWriteHandler(nioChannel, NioTransport.this.pageCacheRecycler, NioTransport.this);
            BytesChannelContext context = new BytesChannelContext(nioChannel, selector, socketConfig, exceptionHandler, handler, new InboundChannelBuffer(NioTransport.this.pageAllocator));
            nioChannel.setContext(context);
            return nioChannel;
        }

        @Override
        public NioTcpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel, Config.ServerSocket socketConfig) {
            NioTcpServerChannel nioChannel = new NioTcpServerChannel(channel);
            Consumer<Exception> exceptionHandler = e -> NioTransport.this.onServerException(nioChannel, e);
            Consumer<NioSocketChannel> acceptor = NioTransport.this::acceptChannel;
            ServerChannelContext context = new ServerChannelContext(nioChannel, this, selector, socketConfig, acceptor, exceptionHandler);
            nioChannel.setContext(context);
            return nioChannel;
        }
    }
}

