/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;

public class TypeQueryBuilder
extends AbstractQueryBuilder<TypeQueryBuilder> {
    public static final String NAME = "type";
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TypeQueryBuilder.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Type queries are deprecated, prefer to filter on a field instead.";
    private final String type;

    public TypeQueryBuilder(String type) {
        if (type == null) {
            throw new IllegalArgumentException("[type] cannot be null");
        }
        this.type = type;
    }

    public TypeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readString() : in.readBytesRef().utf8ToString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeString(this.type);
        } else {
            out.writeBytesRef(new BytesRef(this.type));
        }
    }

    public String type() {
        return this.type;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(VALUE_FIELD.getPreferredName(), this.type);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static TypeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    type = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[type] filter doesn't support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[type] filter doesn't support [" + currentFieldName + "]", new Object[0]);
        }
        if (type == null) {
            throw new ParsingException(parser.getTokenLocation(), "[type] filter needs to be provided with a value for the type", new Object[0]);
        }
        return (TypeQueryBuilder)((TypeQueryBuilder)new TypeQueryBuilder(type).boost(boost)).queryName(queryName);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        deprecationLogger.deprecate(DeprecationCategory.TYPES, "type_query", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        if (context.getType().equals(this.type)) {
            return Queries.newNonNestedFilter(context.indexVersionCreated());
        }
        return new MatchNoDocsQuery();
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.type);
    }

    @Override
    protected boolean doEquals(TypeQueryBuilder other) {
        return Objects.equals(this.type, other.type);
    }
}

