/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.lookup.SearchLookup;

public class CompositeRuntimeField
implements RuntimeField {
    public static final String CONTENT_TYPE = "composite";
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(name -> new RuntimeField.Builder((String)name){
        private final FieldMapper.Parameter<Script> script = new FieldMapper.Parameter<Script>("script", false, () -> null, RuntimeField::parseScript, RuntimeField.initializerNotSupported()).setValidator(s -> {
            if (s == null) {
                throw new IllegalArgumentException("composite runtime field [" + this.name + "] must declare a [script]");
            }
        });
        private final FieldMapper.Parameter<Map<String, Object>> fields = new FieldMapper.Parameter<Map>("fields", false, Collections::emptyMap, (f, p, o) -> CompositeRuntimeField.access$000(f, o), RuntimeField.initializerNotSupported()).setValidator(objectMap -> {
            if (objectMap == null || objectMap.isEmpty()) {
                throw new IllegalArgumentException("composite runtime field [" + this.name + "] must declare its [fields]");
            }
        });

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            ArrayList parameters = new ArrayList(super.getParameters());
            parameters.add(this.script);
            parameters.add(this.fields);
            return Collections.unmodifiableList(parameters);
        }

        @Override
        protected RuntimeField createChildRuntimeField(MappingParserContext parserContext, String parent, Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
            throw new IllegalArgumentException("Composite field [" + this.name + "] cannot be a child of composite field [" + parent + "]");
        }

        @Override
        protected RuntimeField createRuntimeField(MappingParserContext parserContext) {
            CompositeFieldScript.Factory factory = parserContext.scriptCompiler().compile(this.script.get(), CompositeFieldScript.CONTEXT);
            Function<RuntimeField.Builder, RuntimeField> builder = b -> b.createChildRuntimeField(parserContext, this.name, lookup -> factory.newFactory(this.name, this.script.get().getParams(), (SearchLookup)lookup));
            Map<String, RuntimeField> runtimeFields = RuntimeField.parseRuntimeFields(this.fields.getValue(), parserContext, builder, false);
            return new CompositeRuntimeField(this.name, this.getParameters(), runtimeFields.values());
        }
    });
    private final String name;
    private final List<FieldMapper.Parameter<?>> parameters;
    private final Collection<RuntimeField> subfields;

    CompositeRuntimeField(String name, List<FieldMapper.Parameter<?>> parameters, Collection<RuntimeField> subfields) {
        this.name = name;
        this.parameters = parameters;
        this.subfields = subfields;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Stream<MappedFieldType> asMappedFieldTypes() {
        return this.subfields.stream().flatMap(RuntimeField::asMappedFieldTypes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", CONTENT_TYPE);
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        for (FieldMapper.Parameter<?> parameter : this.parameters) {
            parameter.toXContent(builder, includeDefaults);
        }
        builder.startObject("fields");
        for (RuntimeField subfield : this.subfields) {
            subfield.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static Map<String, Object> parseFields(String name, Object fieldsObject) {
        if (!(fieldsObject instanceof Map)) {
            throw new MapperParsingException("[fields] must be an object, got " + fieldsObject.getClass().getSimpleName() + "[" + fieldsObject + "] for field [" + name + "]");
        }
        Map fields = (Map)fieldsObject;
        return fields;
    }
}

