/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.List;

public class HttpStats
implements Writeable,
ToXContentFragment {
    private final long serverOpen;
    private final long totalOpen;
    private final java.util.List<ClientStats> clientStats;

    public HttpStats(java.util.List<ClientStats> clientStats, long serverOpen, long totalOpened) {
        this.clientStats = clientStats;
        this.serverOpen = serverOpen;
        this.totalOpen = totalOpened;
    }

    public HttpStats(long serverOpen, long totalOpened) {
        this(List.of(), serverOpen, totalOpened);
    }

    public HttpStats(StreamInput in) throws IOException {
        this.serverOpen = in.readVLong();
        this.totalOpen = in.readVLong();
        this.clientStats = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readList(ClientStats::new) : List.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.totalOpen);
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeList(this.clientStats);
        }
    }

    public long getServerOpen() {
        return this.serverOpen;
    }

    public long getTotalOpen() {
        return this.totalOpen;
    }

    public java.util.List<ClientStats> getClientStats() {
        return this.clientStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.field("current_open", this.serverOpen);
        builder.field("total_opened", this.totalOpen);
        builder.startArray("clients");
        for (ClientStats clientStats : this.clientStats) {
            clientStats.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String CURRENT_OPEN = "current_open";
        static final String TOTAL_OPENED = "total_opened";
        static final String CLIENTS = "clients";
        static final String CLIENT_ID = "id";
        static final String CLIENT_AGENT = "agent";
        static final String CLIENT_LOCAL_ADDRESS = "local_address";
        static final String CLIENT_REMOTE_ADDRESS = "remote_address";
        static final String CLIENT_LAST_URI = "last_uri";
        static final String CLIENT_OPENED_TIME_MILLIS = "opened_time_millis";
        static final String CLIENT_CLOSED_TIME_MILLIS = "closed_time_millis";
        static final String CLIENT_LAST_REQUEST_TIME_MILLIS = "last_request_time_millis";
        static final String CLIENT_REQUEST_COUNT = "request_count";
        static final String CLIENT_REQUEST_SIZE_BYTES = "request_size_bytes";
        static final String CLIENT_FORWARDED_FOR = "x_forwarded_for";
        static final String CLIENT_OPAQUE_ID = "x_opaque_id";

        Fields() {
        }
    }

    public static class ClientStats
    implements Writeable,
    ToXContentFragment {
        final int id;
        String agent;
        String localAddress;
        String remoteAddress;
        String lastUri;
        String forwardedFor;
        String opaqueId;
        long openedTimeMillis;
        long closedTimeMillis = -1L;
        volatile long lastRequestTimeMillis = -1L;
        final LongAdder requestCount = new LongAdder();
        final LongAdder requestSizeBytes = new LongAdder();

        ClientStats(long openedTimeMillis) {
            this.id = System.identityHashCode(this);
            this.openedTimeMillis = openedTimeMillis;
        }

        public ClientStats(String agent, String localAddress, String remoteAddress, String lastUri, String forwardedFor, String opaqueId, long openedTimeMillis, long closedTimeMillis, long lastRequestTimeMillis, long requestCount, long requestSizeBytes) {
            this.id = System.identityHashCode(this);
            this.agent = agent;
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
            this.lastUri = lastUri;
            this.forwardedFor = forwardedFor;
            this.opaqueId = opaqueId;
            this.openedTimeMillis = openedTimeMillis;
            this.closedTimeMillis = closedTimeMillis;
            this.lastRequestTimeMillis = lastRequestTimeMillis;
            this.requestCount.add(requestCount);
            this.requestSizeBytes.add(requestSizeBytes);
        }

        ClientStats(StreamInput in) throws IOException {
            this.id = in.readInt();
            this.agent = in.readOptionalString();
            this.localAddress = in.readOptionalString();
            this.remoteAddress = in.readOptionalString();
            this.lastUri = in.readOptionalString();
            this.forwardedFor = in.readOptionalString();
            this.opaqueId = in.readOptionalString();
            this.openedTimeMillis = in.readLong();
            this.closedTimeMillis = in.readLong();
            this.lastRequestTimeMillis = in.readLong();
            this.requestCount.add(in.readLong());
            this.requestSizeBytes.add(in.readLong());
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            if (this.agent != null) {
                builder.field("agent", this.agent);
            }
            if (this.localAddress != null) {
                builder.field("local_address", this.localAddress);
            }
            if (this.remoteAddress != null) {
                builder.field("remote_address", this.remoteAddress);
            }
            if (this.lastUri != null) {
                builder.field("last_uri", this.lastUri);
            }
            if (this.forwardedFor != null) {
                builder.field("x_forwarded_for", this.forwardedFor);
            }
            if (this.opaqueId != null) {
                builder.field("x_opaque_id", this.opaqueId);
            }
            builder.field("opened_time_millis", this.openedTimeMillis);
            if (this.closedTimeMillis != -1L) {
                builder.field("closed_time_millis", this.closedTimeMillis);
            }
            builder.field("last_request_time_millis", this.lastRequestTimeMillis);
            builder.field("request_count", this.requestCount.longValue());
            builder.field("request_size_bytes", this.requestSizeBytes.longValue());
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.id);
            out.writeOptionalString(this.agent);
            out.writeOptionalString(this.localAddress);
            out.writeOptionalString(this.remoteAddress);
            out.writeOptionalString(this.lastUri);
            out.writeOptionalString(this.forwardedFor);
            out.writeOptionalString(this.opaqueId);
            out.writeLong(this.openedTimeMillis);
            out.writeLong(this.closedTimeMillis);
            out.writeLong(this.lastRequestTimeMillis);
            out.writeLong(this.requestCount.longValue());
            out.writeLong(this.requestSizeBytes.longValue());
        }
    }
}

