/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.node.ReportingService;

public class HttpInfo
implements ReportingService.Info {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(HttpInfo.class);
    private static final boolean CNAME_IN_PUBLISH_HOST = System.getProperty("es.http.cname_in_publish_address") != null;
    private final BoundTransportAddress address;
    private final long maxContentLength;

    public HttpInfo(StreamInput in) throws IOException {
        this(new BoundTransportAddress(in), in.readLong());
    }

    public HttpInfo(BoundTransportAddress address, long maxContentLength) {
        this.address = address;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        out.writeLong(this.maxContentLength);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.array("bound_address", this.address.boundAddresses());
        TransportAddress publishAddress = this.address.publishAddress();
        String publishAddressString = publishAddress.toString();
        String hostString = publishAddress.address().getHostString();
        if (CNAME_IN_PUBLISH_HOST) {
            deprecationLogger.deprecate(DeprecationCategory.SETTINGS, "cname_in_publish_address", "es.http.cname_in_publish_address system property is deprecated and no longer affects http.publish_address formatting. Remove this property to get rid of this deprecation warning.", new Object[0]);
        }
        if (!InetAddresses.isInetAddress(hostString)) {
            publishAddressString = hostString + '/' + publishAddress.toString();
        }
        builder.field("publish_address", publishAddressString);
        builder.humanReadableField("max_content_length_in_bytes", "max_content_length", this.maxContentLength());
        builder.endObject();
        return builder;
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public ByteSizeValue maxContentLength() {
        return new ByteSizeValue(this.maxContentLength);
    }

    public ByteSizeValue getMaxContentLength() {
        return this.maxContentLength();
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String BOUND_ADDRESS = "bound_address";
        static final String PUBLISH_ADDRESS = "publish_address";
        static final String MAX_CONTENT_LENGTH = "max_content_length";
        static final String MAX_CONTENT_LENGTH_IN_BYTES = "max_content_length_in_bytes";

        Fields() {
        }
    }
}

