/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;

public class ShutdownShardMigrationStatus
implements Writeable,
ToXContentObject {
    private final SingleNodeShutdownMetadata.Status status;
    private final long shardsRemaining;
    @Nullable
    private final String explanation;

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long shardsRemaining) {
        this(status, shardsRemaining, null);
    }

    public ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status status, long shardsRemaining, @Nullable String explanation) {
        this.status = Objects.requireNonNull(status, "status must not be null");
        this.shardsRemaining = shardsRemaining;
        this.explanation = explanation;
    }

    public ShutdownShardMigrationStatus(StreamInput in) throws IOException {
        this.status = in.readEnum(SingleNodeShutdownMetadata.Status.class);
        this.shardsRemaining = in.readLong();
        this.explanation = in.readOptionalString();
    }

    public long getShardsRemaining() {
        return this.shardsRemaining;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public SingleNodeShutdownMetadata.Status getStatus() {
        return this.status;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("status", (Object)this.status);
        builder.field("shard_migrations_remaining", this.shardsRemaining);
        if (Objects.nonNull(this.explanation)) {
            builder.field("explanation", this.explanation);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.status);
        out.writeLong(this.shardsRemaining);
        out.writeOptionalString(this.explanation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShutdownShardMigrationStatus)) {
            return false;
        }
        ShutdownShardMigrationStatus that = (ShutdownShardMigrationStatus)o;
        return this.shardsRemaining == that.shardsRemaining && this.status == that.status && Objects.equals(this.explanation, that.explanation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.shardsRemaining, this.explanation});
    }

    public String toString() {
        return Strings.toString(this);
    }
}

