/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DiffableStringMap
extends AbstractMap<String, String>
implements Diffable<DiffableStringMap> {
    public static final DiffableStringMap EMPTY = new DiffableStringMap(Collections.emptyMap());
    private final Map<String, String> innerMap;

    public static DiffableStringMap readFrom(StreamInput in) throws IOException {
        Map<String, Object> map = in.readMap();
        return map.isEmpty() ? EMPTY : new DiffableStringMap(map);
    }

    DiffableStringMap(Map<String, String> map) {
        this.innerMap = Collections.unmodifiableMap(map);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.innerMap);
    }

    @Override
    public Diff<DiffableStringMap> diff(DiffableStringMap previousState) {
        return new DiffableStringMapDiff(previousState, this);
    }

    public static Diff<DiffableStringMap> readDiffFrom(StreamInput in) throws IOException {
        return new DiffableStringMapDiff(in);
    }

    public static class DiffableStringMapDiff
    implements Diff<DiffableStringMap> {
        public static final DiffableStringMapDiff EMPTY = new DiffableStringMapDiff(EMPTY, EMPTY);
        private final List<String> deletes;
        private final Map<String, String> upserts;

        private DiffableStringMapDiff(DiffableStringMap before, DiffableStringMap after) {
            ArrayList<String> tempDeletes = new ArrayList<String>();
            HashMap<String, String> tempUpserts = new HashMap<String, String>();
            for (String string : before.keySet()) {
                if (after.containsKey(string)) continue;
                tempDeletes.add(string);
            }
            for (Map.Entry entry : after.entrySet()) {
                String beforePart = before.get(entry.getKey());
                if (beforePart == null) {
                    tempUpserts.put((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (((String)entry.getValue()).equals(beforePart)) continue;
                tempUpserts.put((String)entry.getKey(), (String)entry.getValue());
            }
            this.deletes = tempDeletes;
            this.upserts = tempUpserts;
        }

        private DiffableStringMapDiff(StreamInput in) throws IOException {
            this.deletes = in.readStringList();
            this.upserts = in.readMap(StreamInput::readString, StreamInput::readString);
        }

        public List<String> getDeletes() {
            return this.deletes;
        }

        public Map<String, Diff<String>> getDiffs() {
            return Collections.emptyMap();
        }

        public Map<String, String> getUpserts() {
            return this.upserts;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.deletes);
            out.writeMap(this.upserts, StreamOutput::writeString, StreamOutput::writeString);
        }

        @Override
        public DiffableStringMap apply(DiffableStringMap part) {
            HashMap<String, String> builder = new HashMap<String, String>(part.innerMap);
            List<String> deletes = this.getDeletes();
            for (String string : deletes) {
                builder.remove(string);
            }
            assert (this.getDiffs().size() == 0) : "there should never be diffs for DiffableStringMap";
            for (Map.Entry entry : this.upserts.entrySet()) {
                builder.put((String)entry.getKey(), (String)entry.getValue());
            }
            return new DiffableStringMap(builder);
        }
    }
}

