/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetIndexTemplatesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<IndexTemplateMetadata> indexTemplates;

    public GetIndexTemplatesResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.indexTemplates = new ArrayList<IndexTemplateMetadata>();
        for (int i = 0; i < size; ++i) {
            this.indexTemplates.add(0, IndexTemplateMetadata.readFrom(in));
        }
    }

    public GetIndexTemplatesResponse(List<IndexTemplateMetadata> indexTemplates) {
        this.indexTemplates = indexTemplates;
    }

    public List<IndexTemplateMetadata> getIndexTemplates() {
        return this.indexTemplates;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.indexTemplates.size());
        for (IndexTemplateMetadata indexTemplate : this.indexTemplates) {
            indexTemplate.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        params = new ToXContent.DelegatingMapParams(Collections.singletonMap("reduce_mappings", "true"), params);
        boolean includeTypeName = params.paramAsBoolean("include_type_name", false);
        builder.startObject();
        for (IndexTemplateMetadata indexTemplateMetadata : this.getIndexTemplates()) {
            if (includeTypeName) {
                IndexTemplateMetadata.Builder.toXContentWithTypes(indexTemplateMetadata, builder, params);
                continue;
            }
            IndexTemplateMetadata.Builder.toXContent(indexTemplateMetadata, builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static GetIndexTemplatesResponse fromXContent(XContentParser parser) throws IOException {
        ArrayList<IndexTemplateMetadata> templates = new ArrayList<IndexTemplateMetadata>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                IndexTemplateMetadata templateMetadata = IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName());
                templates.add(templateMetadata);
            }
            token = parser.nextToken();
        }
        return new GetIndexTemplatesResponse(templates);
    }
}

