/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class SnapshotsStatusRequest
extends MasterNodeRequest<SnapshotsStatusRequest> {
    private String repository = "_all";
    private String[] snapshots = Strings.EMPTY_ARRAY;
    private boolean ignoreUnavailable;

    public SnapshotsStatusRequest() {
    }

    public SnapshotsStatusRequest(String repository, String[] snapshots) {
        this.repository = repository;
        this.snapshots = snapshots;
    }

    public SnapshotsStatusRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.snapshots = in.readStringArray();
        this.ignoreUnavailable = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeStringArray(this.snapshots);
        out.writeBoolean(this.ignoreUnavailable);
    }

    public SnapshotsStatusRequest(String repository) {
        this.repository = repository;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.snapshots == null) {
            validationException = ValidateActions.addValidationError("snapshots is null", validationException);
        }
        return validationException;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    public SnapshotsStatusRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public SnapshotsStatusRequest snapshots(String[] snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public SnapshotsStatusRequest ignoreUnavailable(boolean ignoreUnavailable) {
        this.ignoreUnavailable = ignoreUnavailable;
        return this;
    }

    public boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }
}

