/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixStats;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixStatsResults;

public class ParsedMatrixStats
extends ParsedAggregation
implements MatrixStats {
    private final Map<String, Long> counts = new LinkedHashMap<String, Long>();
    private final Map<String, Double> means = new HashMap<String, Double>();
    private final Map<String, Double> variances = new HashMap<String, Double>();
    private final Map<String, Double> skewness = new HashMap<String, Double>();
    private final Map<String, Double> kurtosis = new HashMap<String, Double>();
    private final Map<String, Map<String, Double>> covariances = new HashMap<String, Map<String, Double>>();
    private final Map<String, Map<String, Double>> correlations = new HashMap<String, Map<String, Double>>();
    private long docCount;
    private static final ObjectParser<ParsedMatrixStats, Void> PARSER = new ObjectParser(ParsedMatrixStats.class.getSimpleName(), true, ParsedMatrixStats::new);

    public String getType() {
        return "matrix_stats";
    }

    private void setDocCount(long docCount) {
        this.docCount = docCount;
    }

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public long getFieldCount(String field) {
        if (!this.counts.containsKey(field)) {
            return 0L;
        }
        return this.counts.get(field);
    }

    @Override
    public double getMean(String field) {
        return ParsedMatrixStats.checkedGet(this.means, field);
    }

    @Override
    public double getVariance(String field) {
        return ParsedMatrixStats.checkedGet(this.variances, field);
    }

    @Override
    public double getSkewness(String field) {
        return ParsedMatrixStats.checkedGet(this.skewness, field);
    }

    @Override
    public double getKurtosis(String field) {
        return ParsedMatrixStats.checkedGet(this.kurtosis, field);
    }

    @Override
    public double getCovariance(String fieldX, String fieldY) {
        if (fieldX.equals(fieldY)) {
            return ParsedMatrixStats.checkedGet(this.variances, fieldX);
        }
        return MatrixStatsResults.getValFromUpperTriangularMatrix(this.covariances, fieldX, fieldY);
    }

    @Override
    public double getCorrelation(String fieldX, String fieldY) {
        if (fieldX.equals(fieldY)) {
            return 1.0;
        }
        return MatrixStatsResults.getValFromUpperTriangularMatrix(this.correlations, fieldX, fieldY);
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
        if (this.counts != null && !this.counts.isEmpty()) {
            builder.startArray("fields");
            for (String fieldName : this.counts.keySet()) {
                builder.startObject();
                builder.field("name", fieldName);
                builder.field("count", this.getFieldCount(fieldName));
                builder.field("mean", this.getMean(fieldName));
                builder.field("variance", this.getVariance(fieldName));
                builder.field("skewness", this.getSkewness(fieldName));
                builder.field("kurtosis", this.getKurtosis(fieldName));
                builder.startObject("covariance");
                Map<String, Double> covars = this.covariances.get(fieldName);
                if (covars != null) {
                    for (Map.Entry<String, Double> covar : covars.entrySet()) {
                        builder.field(covar.getKey(), covar.getValue());
                    }
                }
                builder.endObject();
                builder.startObject("correlation");
                Map<String, Double> correls = this.correlations.get(fieldName);
                if (correls != null) {
                    for (Map.Entry<String, Double> correl : correls.entrySet()) {
                        builder.field(correl.getKey(), correl.getValue());
                    }
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    private static <T> T checkedGet(Map<String, T> values, String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("field name cannot be null");
        }
        if (!values.containsKey(fieldName)) {
            throw new IllegalArgumentException("field " + fieldName + " does not exist");
        }
        return values.get(fieldName);
    }

    public static ParsedMatrixStats fromXContent(XContentParser parser, String name) throws IOException {
        ParsedMatrixStats aggregation = (ParsedMatrixStats)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedMatrixStats.declareAggregationFields(PARSER);
        PARSER.declareLong(ParsedMatrixStats::setDocCount, Aggregation.CommonFields.DOC_COUNT);
        PARSER.declareObjectArray((matrixStats, results) -> {
            for (ParsedMatrixStatsResult result : results) {
                String fieldName = result.name;
                matrixStats.counts.put(fieldName, result.count);
                matrixStats.means.put(fieldName, result.mean);
                matrixStats.variances.put(fieldName, result.variance);
                matrixStats.skewness.put(fieldName, result.skewness);
                matrixStats.kurtosis.put(fieldName, result.kurtosis);
                matrixStats.covariances.put(fieldName, result.covariances);
                matrixStats.correlations.put(fieldName, result.correlations);
            }
        }, (p, c) -> ParsedMatrixStatsResult.fromXContent(p), new ParseField("fields", new String[0]));
    }

    static class ParsedMatrixStatsResult {
        String name;
        Long count;
        Double mean;
        Double variance;
        Double skewness;
        Double kurtosis;
        Map<String, Double> covariances;
        Map<String, Double> correlations;
        private static final ObjectParser<ParsedMatrixStatsResult, Void> RESULT_PARSER = new ObjectParser(ParsedMatrixStatsResult.class.getSimpleName(), true, ParsedMatrixStatsResult::new);

        ParsedMatrixStatsResult() {
        }

        private static Double mapValueAsDouble(Object value) {
            if (value instanceof Double) {
                return (Double)value;
            }
            return Double.valueOf(Objects.toString(value));
        }

        static ParsedMatrixStatsResult fromXContent(XContentParser parser) throws IOException {
            return (ParsedMatrixStatsResult)RESULT_PARSER.parse(parser, null);
        }

        static {
            RESULT_PARSER.declareString((result, name) -> {
                result.name = name;
            }, new ParseField("name", new String[0]));
            RESULT_PARSER.declareLong((result, count) -> {
                result.count = count;
            }, new ParseField("count", new String[0]));
            RESULT_PARSER.declareDouble((result, mean) -> {
                result.mean = mean;
            }, new ParseField("mean", new String[0]));
            RESULT_PARSER.declareDouble((result, variance) -> {
                result.variance = variance;
            }, new ParseField("variance", new String[0]));
            RESULT_PARSER.declareDouble((result, skewness) -> {
                result.skewness = skewness;
            }, new ParseField("skewness", new String[0]));
            RESULT_PARSER.declareDouble((result, kurtosis) -> {
                result.kurtosis = kurtosis;
            }, new ParseField("kurtosis", new String[0]));
            RESULT_PARSER.declareObject((result, covars) -> {
                result.covariances = new LinkedHashMap<String, Double>(covars.size());
                for (Map.Entry covar : covars.entrySet()) {
                    result.covariances.put((String)covar.getKey(), ParsedMatrixStatsResult.mapValueAsDouble(covar.getValue()));
                }
            }, (p, c) -> p.mapOrdered(), new ParseField("covariance", new String[0]));
            RESULT_PARSER.declareObject((result, correls) -> {
                result.correlations = new LinkedHashMap<String, Double>(correls.size());
                for (Map.Entry correl : correls.entrySet()) {
                    result.correlations.put((String)correl.getKey(), ParsedMatrixStatsResult.mapValueAsDouble(correl.getValue()));
                }
            }, (p, c) -> p.mapOrdered(), new ParseField("correlation", new String[0]));
        }
    }
}

