/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.core.watcher.watch.WatchStatus;

public class QueryWatchesAction
extends ActionType<Response> {
    public static final QueryWatchesAction INSTANCE = new QueryWatchesAction();
    public static final String NAME = "cluster:monitor/xpack/watcher/watch/query";

    private QueryWatchesAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<Item> watches;
        private final long watchTotalCount;

        public Response(long watchTotalCount, List<Item> watches) {
            this.watches = watches;
            this.watchTotalCount = watchTotalCount;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.watches = in.readList(Item::new);
            this.watchTotalCount = in.readVLong();
        }

        public List<Item> getWatches() {
            return this.watches;
        }

        public long getWatchTotalCount() {
            return this.watchTotalCount;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.watches);
            out.writeVLong(this.watchTotalCount);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("count", this.watchTotalCount);
            builder.startArray("watches");
            for (Item watch : this.watches) {
                builder.startObject();
                watch.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.watchTotalCount == response.watchTotalCount && this.watches.equals(response.watches);
        }

        public int hashCode() {
            return Objects.hash(this.watches, this.watchTotalCount);
        }

        public static class Item
        implements Writeable,
        ToXContentFragment {
            private final String id;
            private final XContentSource source;
            private final WatchStatus status;
            private final long seqNo;
            private final long primaryTerm;

            public Item(String id, XContentSource source, WatchStatus status, long seqNo, long primaryTerm) {
                this.id = id;
                this.source = source;
                this.status = status;
                this.seqNo = seqNo;
                this.primaryTerm = primaryTerm;
            }

            public String getId() {
                return this.id;
            }

            public XContentSource getSource() {
                return this.source;
            }

            public WatchStatus getStatus() {
                return this.status;
            }

            public long getSeqNo() {
                return this.seqNo;
            }

            public long getPrimaryTerm() {
                return this.primaryTerm;
            }

            public Item(StreamInput in) throws IOException {
                this.id = in.readString();
                this.source = XContentSource.readFrom(in);
                this.status = new WatchStatus(in);
                this.seqNo = in.readZLong();
                this.primaryTerm = in.readVLong();
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.id);
                XContentSource.writeTo(this.source, out);
                this.status.writeTo(out);
                out.writeZLong(this.seqNo);
                out.writeVLong(this.primaryTerm);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("_id", this.id);
                builder.field("watch", (ToXContent)this.source, params);
                builder.field("status", (ToXContent)this.status, params);
                builder.field("_seq_no", this.seqNo);
                builder.field("_primary_term", this.primaryTerm);
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Item item = (Item)o;
                return this.seqNo == item.seqNo && this.primaryTerm == item.primaryTerm && this.id.equals(item.id) && this.source.equals(item.source);
            }

            public int hashCode() {
                return Objects.hash(this.id, this.source, this.seqNo, this.primaryTerm);
            }
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
        public static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
        public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
        public static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
        public static final ParseField SEARCH_AFTER_FIELD = new ParseField("search_after", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("query_watches_request", true, (args, c) -> {
            Integer from = (Integer)args[0];
            Integer size = (Integer)args[1];
            QueryBuilder query = (QueryBuilder)args[2];
            List sort = (List)args[3];
            SearchAfterBuilder searchAfter = (SearchAfterBuilder)args[4];
            return new Request(from, size, query, sort, searchAfter);
        });
        private final Integer from;
        private final Integer size;
        private final QueryBuilder query;
        private final List<FieldSortBuilder> sorts;
        private final SearchAfterBuilder searchAfter;

        public static Request fromXContent(XContentParser parser) throws IOException {
            return (Request)((Object)PARSER.parse(parser, null));
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.from = in.readOptionalVInt();
            this.size = in.readOptionalVInt();
            this.query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
            this.sorts = in.readBoolean() ? in.readList(FieldSortBuilder::new) : null;
            this.searchAfter = (SearchAfterBuilder)in.readOptionalWriteable(SearchAfterBuilder::new);
        }

        public Request(Integer from, Integer size, QueryBuilder query, List<FieldSortBuilder> sorts, SearchAfterBuilder searchAfter) {
            this.from = from;
            this.size = size;
            this.query = query;
            this.sorts = sorts;
            this.searchAfter = searchAfter;
        }

        public Integer getFrom() {
            return this.from;
        }

        public Integer getSize() {
            return this.size;
        }

        public QueryBuilder getQuery() {
            return this.query;
        }

        public List<FieldSortBuilder> getSorts() {
            return this.sorts;
        }

        public SearchAfterBuilder getSearchAfter() {
            return this.searchAfter;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalVInt(this.from);
            out.writeOptionalVInt(this.size);
            out.writeOptionalNamedWriteable((NamedWriteable)this.query);
            if (this.sorts != null) {
                out.writeBoolean(true);
                out.writeList(this.sorts);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalWriteable((Writeable)this.searchAfter);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.from != null) {
                builder.field(FROM_FIELD.getPreferredName(), this.from);
            }
            if (this.size != null) {
                builder.field(SIZE_FIELD.getPreferredName(), this.size);
            }
            if (this.query != null) {
                builder.field(QUERY_FIELD.getPreferredName(), (ToXContent)this.query);
            }
            if (this.sorts != null) {
                builder.startArray(SORT_FIELD.getPreferredName());
                for (FieldSortBuilder sort : this.sorts) {
                    sort.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.searchAfter != null) {
                builder.array(SEARCH_AFTER_FIELD.getPreferredName(), this.searchAfter.getSortValues());
            }
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.from, request.from) && Objects.equals(this.size, request.size) && Objects.equals(this.query, request.query) && Objects.equals(this.sorts, request.sorts) && Objects.equals(this.searchAfter, request.searchAfter);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.size, this.query, this.sorts, this.searchAfter);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), FROM_FIELD);
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SIZE_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), QUERY_FIELD);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                String fieldName = null;
                FieldSortBuilder result = null;
                XContentParser.Token token = p.nextToken();
                while (token != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = p.currentName();
                    } else {
                        result = FieldSortBuilder.fromXContent((XContentParser)p, (String)fieldName);
                    }
                    token = p.nextToken();
                }
                return result;
            }, SORT_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchAfterBuilder.fromXContent((XContentParser)p), SEARCH_AFTER_FIELD, ObjectParser.ValueType.VALUE_ARRAY);
        }
    }
}

