/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface Action
extends ToXContentObject {
    public String type();

    public static interface Builder<A extends Action> {
        public A build();
    }

    public static abstract class Result
    implements ToXContentFragment {
        protected final String type;
        protected final Status status;

        protected Result(String type, Status status) {
            this.type = type;
            this.status = status;
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public static enum Status {
            SUCCESS,
            FAILURE,
            PARTIAL_FAILURE,
            ACKNOWLEDGED,
            THROTTLED,
            CONDITION_FAILED,
            SIMULATED;


            public String value() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }

        public static class ConditionFailed
        extends StoppedResult {
            public ConditionFailed(String type, String reason, Object ... args) {
                super(type, Status.CONDITION_FAILED, reason, args);
            }
        }

        public static class Acknowledged
        extends StoppedResult {
            public Acknowledged(String type, String reason) {
                super(type, Status.ACKNOWLEDGED, reason, new Object[0]);
            }
        }

        public static class Throttled
        extends StoppedResult {
            public Throttled(String type, String reason) {
                super(type, Status.THROTTLED, reason, new Object[0]);
            }
        }

        public static class FailureWithException
        extends Result {
            private final Exception exception;

            public FailureWithException(String type, Exception exception) {
                super(type, Status.FAILURE);
                this.exception = exception;
            }

            public Exception getException() {
                return this.exception;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                ElasticsearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.exception, (boolean)true);
                return builder;
            }
        }

        public static class Failure
        extends StoppedResult {
            public Failure(String type, String reason, Object ... args) {
                super(type, Status.FAILURE, reason, args);
            }
        }

        public static class StoppedResult
        extends Result {
            private static ParseField REASON = new ParseField("reason", new String[0]);
            private final String reason;

            protected StoppedResult(String type, Status status, String reason, Object ... args) {
                super(type, status);
                this.reason = LoggerMessageFormat.format((String)reason, (Object[])args);
            }

            public String reason() {
                return this.reason;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.field(REASON.getPreferredName(), this.reason);
            }
        }
    }
}

