/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;

public final class GetUserPrivilegesResponse
extends ActionResponse {
    private Set<String> cluster;
    private Set<ConfigurableClusterPrivilege> configurableClusterPrivileges;
    private Set<Indices> index;
    private Set<RoleDescriptor.ApplicationResourcePrivileges> application;
    private Set<String> runAs;

    public GetUserPrivilegesResponse(StreamInput in) throws IOException {
        super(in);
        this.cluster = Collections.unmodifiableSet(in.readSet(StreamInput::readString));
        this.configurableClusterPrivileges = Collections.unmodifiableSet(in.readSet(ConfigurableClusterPrivileges.READER));
        this.index = Collections.unmodifiableSet(in.readSet(Indices::new));
        this.application = Collections.unmodifiableSet(in.readSet(RoleDescriptor.ApplicationResourcePrivileges::new));
        this.runAs = Collections.unmodifiableSet(in.readSet(StreamInput::readString));
    }

    public GetUserPrivilegesResponse(Set<String> cluster, Set<ConfigurableClusterPrivilege> conditionalCluster, Set<Indices> index, Set<RoleDescriptor.ApplicationResourcePrivileges> application, Set<String> runAs) {
        this.cluster = Collections.unmodifiableSet(cluster);
        this.configurableClusterPrivileges = Collections.unmodifiableSet(conditionalCluster);
        this.index = Collections.unmodifiableSet(index);
        this.application = Collections.unmodifiableSet(application);
        this.runAs = Collections.unmodifiableSet(runAs);
    }

    public Set<String> getClusterPrivileges() {
        return this.cluster;
    }

    public Set<ConfigurableClusterPrivilege> getConditionalClusterPrivileges() {
        return this.configurableClusterPrivileges;
    }

    public Set<Indices> getIndexPrivileges() {
        return this.index;
    }

    public Set<RoleDescriptor.ApplicationResourcePrivileges> getApplicationPrivileges() {
        return this.application;
    }

    public Set<String> getRunAs() {
        return this.runAs;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.cluster, StreamOutput::writeString);
        out.writeCollection(this.configurableClusterPrivileges, ConfigurableClusterPrivileges.WRITER);
        out.writeCollection(this.index);
        out.writeCollection(this.application);
        out.writeCollection(this.runAs, StreamOutput::writeString);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        GetUserPrivilegesResponse that = (GetUserPrivilegesResponse)((Object)other);
        return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.configurableClusterPrivileges, that.configurableClusterPrivileges) && Objects.equals(this.index, that.index) && Objects.equals(this.application, that.application) && Objects.equals(this.runAs, that.runAs);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.configurableClusterPrivileges, this.index, this.application, this.runAs);
    }

    public static class Indices
    implements ToXContentObject,
    Writeable {
        private final Set<String> indices;
        private final Set<String> privileges;
        private final Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> fieldSecurity;
        private final Set<BytesReference> queries;
        private final boolean allowRestrictedIndices;

        public Indices(Collection<String> indices, Collection<String> privileges, Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> fieldSecurity, Set<BytesReference> queries, boolean allowRestrictedIndices) {
            this.indices = Collections.unmodifiableSet(new TreeSet<String>(Objects.requireNonNull(indices)));
            this.privileges = Collections.unmodifiableSet(new TreeSet<String>(Objects.requireNonNull(privileges)));
            this.fieldSecurity = Collections.unmodifiableSet(Objects.requireNonNull(fieldSecurity));
            this.queries = Collections.unmodifiableSet(Objects.requireNonNull(queries));
            this.allowRestrictedIndices = allowRestrictedIndices;
        }

        public Indices(StreamInput in) throws IOException {
            this.indices = Collections.unmodifiableSet(new TreeSet(in.readSet(StreamInput::readString)));
            this.privileges = Collections.unmodifiableSet(new TreeSet(in.readSet(StreamInput::readString)));
            this.fieldSecurity = Collections.unmodifiableSet(in.readSet(input -> {
                String[] grant = input.readOptionalStringArray();
                String[] exclude = input.readOptionalStringArray();
                return new FieldPermissionsDefinition.FieldGrantExcludeGroup(grant, exclude);
            }));
            this.queries = Collections.unmodifiableSet(in.readSet(StreamInput::readBytesReference));
            this.allowRestrictedIndices = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readBoolean() : false;
        }

        public Set<String> getIndices() {
            return this.indices;
        }

        public Set<String> getPrivileges() {
            return this.privileges;
        }

        public Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> getFieldSecurity() {
            return this.fieldSecurity;
        }

        public Set<BytesReference> getQueries() {
            return this.queries;
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("indices=[").append(Strings.collectionToCommaDelimitedString(this.indices)).append("], allow_restricted_indices=[").append(this.allowRestrictedIndices).append("], privileges=[").append(Strings.collectionToCommaDelimitedString(this.privileges)).append("]");
            if (!this.fieldSecurity.isEmpty()) {
                sb.append(", fls=[").append(Strings.collectionToCommaDelimitedString(this.fieldSecurity)).append("]");
            }
            if (!this.queries.isEmpty()) {
                sb.append(", dls=[").append(this.queries.stream().map(BytesReference::utf8ToString).collect(Collectors.joining(","))).append("]");
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Indices that = (Indices)o;
            return this.indices.equals(that.indices) && this.privileges.equals(that.privileges) && this.fieldSecurity.equals(that.fieldSecurity) && this.queries.equals(that.queries) && this.allowRestrictedIndices == that.allowRestrictedIndices;
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.privileges, this.fieldSecurity, this.queries, this.allowRestrictedIndices);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(RoleDescriptor.Fields.NAMES.getPreferredName(), this.indices);
            builder.field(RoleDescriptor.Fields.PRIVILEGES.getPreferredName(), this.privileges);
            if (this.fieldSecurity.stream().anyMatch(g -> this.nonEmpty(g.getGrantedFields()) || this.nonEmpty(g.getExcludedFields()))) {
                builder.startArray(RoleDescriptor.Fields.FIELD_PERMISSIONS.getPreferredName());
                List sortedFieldSecurity = this.fieldSecurity.stream().sorted().collect(Collectors.toList());
                for (FieldPermissionsDefinition.FieldGrantExcludeGroup group : sortedFieldSecurity) {
                    builder.startObject();
                    if (this.nonEmpty(group.getGrantedFields())) {
                        builder.array(RoleDescriptor.Fields.GRANT_FIELDS.getPreferredName(), group.getGrantedFields());
                    }
                    if (this.nonEmpty(group.getExcludedFields())) {
                        builder.array(RoleDescriptor.Fields.EXCEPT_FIELDS.getPreferredName(), group.getExcludedFields());
                    }
                    builder.endObject();
                }
                builder.endArray();
            }
            if (!this.queries.isEmpty()) {
                builder.startArray(RoleDescriptor.Fields.QUERY.getPreferredName());
                for (BytesReference q : this.queries) {
                    builder.value(q.utf8ToString());
                }
                builder.endArray();
            }
            builder.field(RoleDescriptor.Fields.ALLOW_RESTRICTED_INDICES.getPreferredName(), this.allowRestrictedIndices);
            return builder.endObject();
        }

        private boolean nonEmpty(String[] grantedFields) {
            return grantedFields != null && grantedFields.length != 0;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.indices, StreamOutput::writeString);
            out.writeCollection(this.privileges, StreamOutput::writeString);
            out.writeCollection(this.fieldSecurity, (output, fields) -> {
                output.writeOptionalStringArray(fields.getGrantedFields());
                output.writeOptionalStringArray(fields.getExcludedFields());
            });
            out.writeCollection(this.queries, StreamOutput::writeBytesReference);
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                out.writeBoolean(this.allowRestrictedIndices);
            }
        }
    }
}

