/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.action.RollableIndexCaps;

public class GetRollupCapsAction
extends ActionType<Response> {
    public static final GetRollupCapsAction INSTANCE = new GetRollupCapsAction();
    public static final String NAME = "cluster:monitor/xpack/rollup/get/caps";
    public static final ParseField CONFIG = new ParseField("config", new String[0]);
    public static final ParseField STATUS = new ParseField("status", new String[0]);

    private GetRollupCapsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements Writeable,
    ToXContentObject {
        private Map<String, RollableIndexCaps> jobs = Collections.emptyMap();

        public Response() {
        }

        public Response(Map<String, RollableIndexCaps> jobs) {
            this.jobs = Collections.unmodifiableMap(Objects.requireNonNull(jobs));
        }

        Response(StreamInput in) throws IOException {
            this.jobs = Collections.unmodifiableMap(in.readMap(StreamInput::readString, RollableIndexCaps::new));
        }

        public Map<String, RollableIndexCaps> getJobs() {
            return this.jobs;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.jobs, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (Map.Entry<String, RollableIndexCaps> entry : this.jobs.entrySet()) {
                entry.getValue().toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobs);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.jobs, other.jobs);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        protected RequestBuilder(ElasticsearchClient client, GetRollupCapsAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentFragment {
        private String indexPattern;

        public Request(String indexPattern) {
            this.indexPattern = Strings.isNullOrEmpty((String)indexPattern) || indexPattern.equals("*") ? "_all" : indexPattern;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indexPattern = in.readString();
        }

        public String getIndexPattern() {
            return this.indexPattern;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.indexPattern);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(RollupField.ID.getPreferredName(), this.indexPattern);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.indexPattern);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.indexPattern, other.indexPattern);
        }
    }
}

